/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.rds.model.transform;

import com.cloudera.com.amazonaws.services.rds.model.EventCategoriesMap;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCategoriesMapStaxUnmarshaller
implements Unmarshaller<EventCategoriesMap, StaxUnmarshallerContext> {
    private static EventCategoriesMapStaxUnmarshaller instance;

    @Override
    public EventCategoriesMap unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventCategoriesMap eventCategoriesMap = new EventCategoriesMap();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return eventCategoriesMap;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceType", targetDepth)) {
                    eventCategoriesMap.setSourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EventCategories/EventCategory", targetDepth)) continue;
                eventCategoriesMap.getEventCategories().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return eventCategoriesMap;
    }

    public static EventCategoriesMapStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventCategoriesMapStaxUnmarshaller();
        }
        return instance;
    }
}

