/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.route53.model.transform;

import com.cloudera.com.amazonaws.services.route53.model.DelegationSet;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegationSetStaxUnmarshaller
implements Unmarshaller<DelegationSet, StaxUnmarshallerContext> {
    private static DelegationSetStaxUnmarshaller instance;

    @Override
    public DelegationSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        DelegationSet delegationSet = new DelegationSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return delegationSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("NameServers/NameServer", targetDepth)) continue;
                delegationSet.getNameServers().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return delegationSet;
    }

    public static DelegationSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DelegationSetStaxUnmarshaller();
        }
        return instance;
    }
}

