/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.s3.transfer.internal;

import com.cloudera.com.amazonaws.services.s3.model.ObjectMetadata;
import com.cloudera.com.amazonaws.services.s3.model.S3Object;
import com.cloudera.com.amazonaws.services.s3.transfer.Download;
import com.cloudera.com.amazonaws.services.s3.transfer.Transfer;
import com.cloudera.com.amazonaws.services.s3.transfer.TransferProgress;
import com.cloudera.com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.cloudera.com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import com.cloudera.com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import java.io.IOException;

public class DownloadImpl
extends AbstractTransfer
implements Download {
    S3Object s3Object;

    public DownloadImpl(String description, TransferProgress transferProgress, com.cloudera.com.amazonaws.event.ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener listener) {
        super(description, transferProgress, progressListenerChain, listener);
        this.s3Object = s3Object;
    }

    @Deprecated
    public DownloadImpl(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener listener) {
        this(description, transferProgress, progressListenerChain.transformToGeneralProgressListenerChain(), s3Object, listener);
    }

    public ObjectMetadata getObjectMetadata() {
        return this.s3Object.getObjectMetadata();
    }

    public String getBucketName() {
        return this.s3Object.getBucketName();
    }

    public String getKey() {
        return this.s3Object.getKey();
    }

    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        DownloadImpl downloadImpl = this;
        synchronized (downloadImpl) {
            this.state = Transfer.TransferState.Canceled;
        }
    }

    public synchronized void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    public void setState(Transfer.TransferState state) {
        super.setState(state);
        if (state == Transfer.TransferState.Completed) {
            this.fireProgressEvent(4);
        }
    }
}

