/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.s3.transfer.internal;

import com.cloudera.com.amazonaws.services.s3.transfer.Transfer;
import com.cloudera.com.amazonaws.services.s3.transfer.TransferProgress;
import com.cloudera.com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.cloudera.com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleFileTransfer
extends AbstractTransfer {
    protected final Collection<? extends Transfer> subTransfers;
    private AtomicBoolean subTransferStarted = new AtomicBoolean(false);

    MultipleFileTransfer(String description, TransferProgress transferProgress, com.cloudera.com.amazonaws.event.ProgressListenerChain progressListenerChain, Collection<? extends Transfer> subTransfers) {
        super(description, transferProgress, progressListenerChain);
        this.subTransfers = subTransfers;
    }

    @Deprecated
    MultipleFileTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, Collection<? extends Transfer> subTransfers) {
        this(description, transferProgress, progressListenerChain.transformToGeneralProgressListenerChain(), subTransfers);
    }

    public void collateFinalState() {
        boolean seenCanceled = false;
        for (Transfer transfer : this.subTransfers) {
            if (transfer.getState() == Transfer.TransferState.Failed) {
                this.setState(Transfer.TransferState.Failed);
                return;
            }
            if (transfer.getState() != Transfer.TransferState.Canceled) continue;
            seenCanceled = true;
        }
        if (seenCanceled) {
            this.setState(Transfer.TransferState.Canceled);
        } else {
            this.setState(Transfer.TransferState.Completed);
        }
    }

    @Override
    public void setState(Transfer.TransferState state) {
        super.setState(state);
        switch (state) {
            case Waiting: {
                this.fireProgressEvent(1);
                break;
            }
            case InProgress: {
                if (!this.subTransferStarted.compareAndSet(false, true)) break;
                this.fireProgressEvent(2);
                break;
            }
            case Completed: {
                this.fireProgressEvent(4);
                break;
            }
            case Canceled: {
                this.fireProgressEvent(16);
                break;
            }
            case Failed: {
                this.fireProgressEvent(8);
                break;
            }
        }
    }
}

