/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpledb.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.cloudera.com.amazonaws.services.simpledb.model.UpdateCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private String itemName;
    private ListWithAutoConstructFlag<ReplaceableAttribute> attributes;
    private UpdateCondition expected;

    public PutAttributesRequest() {
    }

    public PutAttributesRequest(String domainName, String itemName, List<ReplaceableAttribute> attributes) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
    }

    public PutAttributesRequest(String domainName, String itemName, List<ReplaceableAttribute> attributes, UpdateCondition expected) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
        this.setExpected(expected);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public PutAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public PutAttributesRequest withItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public List<ReplaceableAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<ReplaceableAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag attributesCopy = new ListWithAutoConstructFlag(attributes.size());
        attributesCopy.addAll(attributes);
        this.attributes = attributesCopy;
    }

    public PutAttributesRequest withAttributes(ReplaceableAttribute ... attributes) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<ReplaceableAttribute>(attributes.length));
        }
        for (ReplaceableAttribute value : attributes) {
            this.getAttributes().add(value);
        }
        return this;
    }

    public PutAttributesRequest withAttributes(Collection<ReplaceableAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag attributesCopy = new ListWithAutoConstructFlag(attributes.size());
            attributesCopy.addAll(attributes);
            this.attributes = attributesCopy;
        }
        return this;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public void setExpected(UpdateCondition expected) {
        this.expected = expected;
    }

    public PutAttributesRequest withExpected(UpdateCondition expected) {
        this.expected = expected;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItemName() != null) {
            sb.append("ItemName: " + this.getItemName() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: " + this.getExpected());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAttributesRequest)) {
            return false;
        }
        PutAttributesRequest other = (PutAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (other.getItemName() != null && !other.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        return other.getExpected() == null || other.getExpected().equals(this.getExpected());
    }
}

