/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpledb.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.simpledb.model.Attribute;
import com.cloudera.com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.cloudera.com.amazonaws.services.simpledb.model.DeletableItem;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDeleteAttributesRequestMarshaller
implements Marshaller<Request<BatchDeleteAttributesRequest>, BatchDeleteAttributesRequest> {
    @Override
    public Request<BatchDeleteAttributesRequest> marshall(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        if (batchDeleteAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchDeleteAttributesRequest> request = new DefaultRequest<BatchDeleteAttributesRequest>(batchDeleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchDeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        if (batchDeleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(batchDeleteAttributesRequest.getDomainName()));
        }
        List<DeletableItem> itemsList = batchDeleteAttributesRequest.getItems();
        int itemsListIndex = 1;
        for (DeletableItem itemsListValue : itemsList) {
            DeletableItem deletableItemMember = itemsListValue;
            if (deletableItemMember != null) {
                if (deletableItemMember.getName() != null) {
                    request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString(deletableItemMember.getName()));
                }
                List<Attribute> attributesList = deletableItemMember.getAttributes();
                int attributesListIndex = 1;
                for (Attribute attributesListValue : attributesList) {
                    Attribute attributeMember = attributesListValue;
                    if (attributeMember != null) {
                        if (attributeMember.getName() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributeMember.getName()));
                        }
                        if (attributeMember.getAlternateNameEncoding() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString(attributeMember.getAlternateNameEncoding()));
                        }
                        if (attributeMember.getValue() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributeMember.getValue()));
                        }
                        if (attributeMember.getAlternateValueEncoding() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString(attributeMember.getAlternateValueEncoding()));
                        }
                    }
                    ++attributesListIndex;
                }
            }
            ++itemsListIndex;
        }
        return request;
    }
}

