/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpledb.model.transform;

import com.cloudera.com.amazonaws.services.simpledb.model.Item;
import com.cloudera.com.amazonaws.services.simpledb.model.transform.AttributeStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemStaxUnmarshaller
implements Unmarshaller<Item, StaxUnmarshallerContext> {
    private static ItemStaxUnmarshaller instance;

    @Override
    public Item unmarshall(StaxUnmarshallerContext context) throws Exception {
        Item item = new Item();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return item;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    item.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name/@encoding", targetDepth)) {
                    item.setAlternateNameEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Attribute", targetDepth)) continue;
                item.getAttributes().add(AttributeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return item;
    }

    public static ItemStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ItemStaxUnmarshaller();
        }
        return instance;
    }
}

