/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleemail;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.Response;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.HandlerChainFactory;
import com.cloudera.com.amazonaws.http.DefaultErrorResponseHandler;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.StaxResponseHandler;
import com.cloudera.com.amazonaws.internal.StaticCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.RequestMetricCollector;
import com.cloudera.com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.cloudera.com.amazonaws.services.simpleemail.model.DeleteIdentityRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.DeleteIdentityResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetSendQuotaRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetSendQuotaResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.ListIdentitiesRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.ListIdentitiesResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyDomainDkimResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyDomainIdentityResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest;
import com.cloudera.com.amazonaws.services.simpleemail.model.VerifyEmailIdentityResult;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.DeleteIdentityRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.DeleteIdentityResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.DeleteVerifiedEmailAddressRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetIdentityDkimAttributesRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetIdentityDkimAttributesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetIdentityNotificationAttributesRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetIdentityNotificationAttributesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetIdentityVerificationAttributesRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetIdentityVerificationAttributesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetSendQuotaRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetSendQuotaResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.ListIdentitiesRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.ListIdentitiesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.MessageRejectedExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SendEmailRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SendEmailResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SendRawEmailRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SendRawEmailResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SetIdentityDkimEnabledRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SetIdentityDkimEnabledResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SetIdentityFeedbackForwardingEnabledRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SetIdentityFeedbackForwardingEnabledResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SetIdentityNotificationTopicRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.SetIdentityNotificationTopicResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyDomainDkimRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyDomainDkimResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyDomainIdentityRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyDomainIdentityResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyEmailAddressRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyEmailIdentityRequestMarshaller;
import com.cloudera.com.amazonaws.services.simpleemail.model.transform.VerifyEmailIdentityResultStaxUnmarshaller;
import com.cloudera.com.amazonaws.transform.StandardErrorUnmarshaller;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleEmailServiceClient
extends AmazonWebServiceClient
implements AmazonSimpleEmailService {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonSimpleEmailServiceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new MessageRejectedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("email.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/cloudera/com/amazonaws/services/simpleemail/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/cloudera/com/amazonaws/services/simpleemail/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityResult deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteIdentityRequest> request = null;
        Response<DeleteIdentityResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteIdentityRequestMarshaller().marshall(deleteIdentityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteIdentityResultStaxUnmarshaller(), executionContext);
            DeleteIdentityResult deleteIdentityResult = response.getAwsResponse();
            return deleteIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVerifiedEmailAddressesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListVerifiedEmailAddressesRequest> request = null;
        Response<ListVerifiedEmailAddressesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListVerifiedEmailAddressesRequestMarshaller().marshall(listVerifiedEmailAddressesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListVerifiedEmailAddressesResultStaxUnmarshaller(), executionContext);
            ListVerifiedEmailAddressesResult listVerifiedEmailAddressesResult = response.getAwsResponse();
            return listVerifiedEmailAddressesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSendStatisticsResult getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSendStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetSendStatisticsRequest> request = null;
        Response<GetSendStatisticsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetSendStatisticsRequestMarshaller().marshall(getSendStatisticsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetSendStatisticsResultStaxUnmarshaller(), executionContext);
            GetSendStatisticsResult getSendStatisticsResult = response.getAwsResponse();
            return getSendStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyEmailIdentityResult verifyEmailIdentity(VerifyEmailIdentityRequest verifyEmailIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyEmailIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<VerifyEmailIdentityRequest> request = null;
        Response<VerifyEmailIdentityResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new VerifyEmailIdentityRequestMarshaller().marshall(verifyEmailIdentityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new VerifyEmailIdentityResultStaxUnmarshaller(), executionContext);
            VerifyEmailIdentityResult verifyEmailIdentityResult = response.getAwsResponse();
            return verifyEmailIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityNotificationAttributesResult getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityNotificationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetIdentityNotificationAttributesRequest> request = null;
        Response<GetIdentityNotificationAttributesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetIdentityNotificationAttributesRequestMarshaller().marshall(getIdentityNotificationAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetIdentityNotificationAttributesResultStaxUnmarshaller(), executionContext);
            GetIdentityNotificationAttributesResult getIdentityNotificationAttributesResult = response.getAwsResponse();
            return getIdentityNotificationAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDomainDkimResult verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyDomainDkimRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<VerifyDomainDkimRequest> request = null;
        Response<VerifyDomainDkimResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new VerifyDomainDkimRequestMarshaller().marshall(verifyDomainDkimRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new VerifyDomainDkimResultStaxUnmarshaller(), executionContext);
            VerifyDomainDkimResult verifyDomainDkimResult = response.getAwsResponse();
            return verifyDomainDkimResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityDkimAttributesResult getIdentityDkimAttributes(GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityDkimAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetIdentityDkimAttributesRequest> request = null;
        Response<GetIdentityDkimAttributesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetIdentityDkimAttributesRequestMarshaller().marshall(getIdentityDkimAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetIdentityDkimAttributesResultStaxUnmarshaller(), executionContext);
            GetIdentityDkimAttributesResult getIdentityDkimAttributesResult = response.getAwsResponse();
            return getIdentityDkimAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyEmailAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<VerifyEmailAddressRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new VerifyEmailAddressRequestMarshaller().marshall(verifyEmailAddressRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendRawEmailResult sendRawEmail(SendRawEmailRequest sendRawEmailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendRawEmailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SendRawEmailRequest> request = null;
        Response<SendRawEmailResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SendRawEmailRequestMarshaller().marshall(sendRawEmailRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SendRawEmailResultStaxUnmarshaller(), executionContext);
            SendRawEmailResult sendRawEmailResult = response.getAwsResponse();
            return sendRawEmailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitiesResult listIdentities(ListIdentitiesRequest listIdentitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListIdentitiesRequest> request = null;
        Response<ListIdentitiesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListIdentitiesRequestMarshaller().marshall(listIdentitiesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListIdentitiesResultStaxUnmarshaller(), executionContext);
            ListIdentitiesResult listIdentitiesResult = response.getAwsResponse();
            return listIdentitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityVerificationAttributesResult getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityVerificationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetIdentityVerificationAttributesRequest> request = null;
        Response<GetIdentityVerificationAttributesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetIdentityVerificationAttributesRequestMarshaller().marshall(getIdentityVerificationAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetIdentityVerificationAttributesResultStaxUnmarshaller(), executionContext);
            GetIdentityVerificationAttributesResult getIdentityVerificationAttributesResult = response.getAwsResponse();
            return getIdentityVerificationAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityDkimEnabledResult setIdentityDkimEnabled(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityDkimEnabledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetIdentityDkimEnabledRequest> request = null;
        Response<SetIdentityDkimEnabledResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetIdentityDkimEnabledRequestMarshaller().marshall(setIdentityDkimEnabledRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SetIdentityDkimEnabledResultStaxUnmarshaller(), executionContext);
            SetIdentityDkimEnabledResult setIdentityDkimEnabledResult = response.getAwsResponse();
            return setIdentityDkimEnabledResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSendQuotaResult getSendQuota(GetSendQuotaRequest getSendQuotaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSendQuotaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetSendQuotaRequest> request = null;
        Response<GetSendQuotaResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetSendQuotaRequestMarshaller().marshall(getSendQuotaRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetSendQuotaResultStaxUnmarshaller(), executionContext);
            GetSendQuotaResult getSendQuotaResult = response.getAwsResponse();
            return getSendQuotaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityFeedbackForwardingEnabledResult setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityFeedbackForwardingEnabledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetIdentityFeedbackForwardingEnabledRequest> request = null;
        Response<SetIdentityFeedbackForwardingEnabledResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetIdentityFeedbackForwardingEnabledRequestMarshaller().marshall(setIdentityFeedbackForwardingEnabledRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SetIdentityFeedbackForwardingEnabledResultStaxUnmarshaller(), executionContext);
            SetIdentityFeedbackForwardingEnabledResult setIdentityFeedbackForwardingEnabledResult = response.getAwsResponse();
            return setIdentityFeedbackForwardingEnabledResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDomainIdentityResult verifyDomainIdentity(VerifyDomainIdentityRequest verifyDomainIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyDomainIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<VerifyDomainIdentityRequest> request = null;
        Response<VerifyDomainIdentityResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new VerifyDomainIdentityRequestMarshaller().marshall(verifyDomainIdentityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new VerifyDomainIdentityResultStaxUnmarshaller(), executionContext);
            VerifyDomainIdentityResult verifyDomainIdentityResult = response.getAwsResponse();
            return verifyDomainIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendEmailResult sendEmail(SendEmailRequest sendEmailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendEmailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SendEmailRequest> request = null;
        Response<SendEmailResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SendEmailRequestMarshaller().marshall(sendEmailRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SendEmailResultStaxUnmarshaller(), executionContext);
            SendEmailResult sendEmailResult = response.getAwsResponse();
            return sendEmailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVerifiedEmailAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteVerifiedEmailAddressRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteVerifiedEmailAddressRequestMarshaller().marshall(deleteVerifiedEmailAddressRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityNotificationTopicResult setIdentityNotificationTopic(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityNotificationTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetIdentityNotificationTopicRequest> request = null;
        Response<SetIdentityNotificationTopicResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetIdentityNotificationTopicRequestMarshaller().marshall(setIdentityNotificationTopicRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SetIdentityNotificationTopicResultStaxUnmarshaller(), executionContext);
            SetIdentityNotificationTopicResult setIdentityNotificationTopicResult = response.getAwsResponse();
            return setIdentityNotificationTopicResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses() throws AmazonServiceException, AmazonClientException {
        return this.listVerifiedEmailAddresses(new ListVerifiedEmailAddressesRequest());
    }

    @Override
    public GetSendStatisticsResult getSendStatistics() throws AmazonServiceException, AmazonClientException {
        return this.getSendStatistics(new GetSendStatisticsRequest());
    }

    @Override
    public ListIdentitiesResult listIdentities() throws AmazonServiceException, AmazonClientException {
        return this.listIdentities(new ListIdentitiesRequest());
    }

    @Override
    public GetSendQuotaResult getSendQuota() throws AmazonServiceException, AmazonClientException {
        return this.getSendQuota(new GetSendQuotaRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

