/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleemail.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.simpleemail.model.Body;
import com.cloudera.com.amazonaws.services.simpleemail.model.Content;
import com.cloudera.com.amazonaws.services.simpleemail.model.Destination;
import com.cloudera.com.amazonaws.services.simpleemail.model.Message;
import com.cloudera.com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    @Override
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        Message messageMessage;
        Destination destinationDestination;
        if (sendEmailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendEmailRequest> request = new DefaultRequest<SendEmailRequest>(sendEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        if (sendEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendEmailRequest.getSource()));
        }
        if ((destinationDestination = sendEmailRequest.getDestination()) != null) {
            List<String> toAddressesList = destinationDestination.getToAddresses();
            int toAddressesListIndex = 1;
            for (String toAddressesListValue : toAddressesList) {
                if (toAddressesListValue != null) {
                    request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString(toAddressesListValue));
                }
                ++toAddressesListIndex;
            }
            List<String> ccAddressesList = destinationDestination.getCcAddresses();
            int ccAddressesListIndex = 1;
            for (String ccAddressesListValue : ccAddressesList) {
                if (ccAddressesListValue != null) {
                    request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString(ccAddressesListValue));
                }
                ++ccAddressesListIndex;
            }
            List<String> bccAddressesList = destinationDestination.getBccAddresses();
            int bccAddressesListIndex = 1;
            for (String bccAddressesListValue : bccAddressesList) {
                if (bccAddressesListValue != null) {
                    request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString(bccAddressesListValue));
                }
                ++bccAddressesListIndex;
            }
        }
        if ((messageMessage = sendEmailRequest.getMessage()) != null) {
            Body bodyBody;
            Content contentSubject = messageMessage.getSubject();
            if (contentSubject != null) {
                if (contentSubject.getData() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString(contentSubject.getData()));
                }
                if (contentSubject.getCharset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString(contentSubject.getCharset()));
                }
            }
            if ((bodyBody = messageMessage.getBody()) != null) {
                Content contentHtml;
                Content contentText = bodyBody.getText();
                if (contentText != null) {
                    if (contentText.getData() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString(contentText.getData()));
                    }
                    if (contentText.getCharset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString(contentText.getCharset()));
                    }
                }
                if ((contentHtml = bodyBody.getHtml()) != null) {
                    if (contentHtml.getData() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString(contentHtml.getData()));
                    }
                    if (contentHtml.getCharset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString(contentHtml.getCharset()));
                    }
                }
            }
        }
        List<String> replyToAddressesList = sendEmailRequest.getReplyToAddresses();
        int replyToAddressesListIndex = 1;
        for (String replyToAddressesListValue : replyToAddressesList) {
            if (replyToAddressesListValue != null) {
                request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString(replyToAddressesListValue));
            }
            ++replyToAddressesListIndex;
        }
        if (sendEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendEmailRequest.getReturnPath()));
        }
        return request;
    }
}

