/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.core;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settable<V>
extends Promise<V> {
    private final List<Runnable> callbacks = new ArrayList<Runnable>();
    private Runnable chainCallback;
    private Promise<V> chainedTo;
    private V value;
    private boolean ready;
    private String description;

    public Settable(V value) {
        this.set(value);
    }

    public Settable() {
    }

    @Override
    public V get() {
        if (!this.ready) {
            throw new IllegalStateException("not ready");
        }
        return this.value;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    public void set(V value) {
        if (this.ready) {
            throw new IllegalStateException("already set to " + this.value);
        }
        this.value = value;
        this.ready = true;
        for (Runnable callback : this.callbacks) {
            callback.run();
        }
    }

    public void chain(final Promise<V> chainTo) {
        if (this.ready) {
            throw new IllegalStateException("already ready");
        }
        if (this.chainCallback != null) {
            throw new IllegalStateException("Already chained. Call unchain() to get rid of the previous chaining.");
        }
        if (chainTo == null) {
            this.set(null);
            return;
        }
        this.chainCallback = new Runnable(){

            public void run() {
                Settable.this.set(chainTo.get());
            }
        };
        chainTo.addCallback(this.chainCallback);
        this.chainedTo = chainTo;
    }

    public void unchain() {
        if (this.chainedTo == null) {
            return;
        }
        if (this.chainedTo.isReady()) {
            throw new IllegalStateException("Cannot unchain from a value which is ready");
        }
        if (this.chainCallback != null) {
            this.chainedTo.removeCallback(this.chainCallback);
            this.chainCallback = null;
            this.chainedTo = null;
        }
    }

    @Override
    protected void addCallback(Runnable callback) {
        if (this.ready) {
            callback.run();
        } else {
            this.callbacks.add(callback);
        }
    }

    @Override
    protected void removeCallback(Runnable callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public String getDescription() {
        if (this.description == null && this.chainedTo != null) {
            return this.chainedTo.getDescription();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Settable [value=" + this.value + ", ready=" + this.ready + "]";
    }
}

