/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.ActivityFailureException;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationBase;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.CurrentActivityExecutionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;

class POJOActivityImplementation
extends ActivityImplementationBase {
    private final Method activity;
    private final Object activitiesImplmentationObject;
    private final ActivityTypeExecutionOptions executionOptions;
    private final DataConverter converter;
    private final ActivityTypeRegistrationOptions registrationOptions;

    public POJOActivityImplementation(Object activitiesImplmentationObject, Method activity, ActivityTypeRegistrationOptions registrationOptions, ActivityTypeExecutionOptions executionOptions, DataConverter converter) {
        this.activitiesImplmentationObject = activitiesImplmentationObject;
        this.activity = activity;
        this.registrationOptions = registrationOptions;
        this.executionOptions = executionOptions;
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String execute(String input, ActivityExecutionContext context) throws ActivityFailureException, CancellationException {
        Object[] inputParameters = this.converter.fromData(input, Object[].class);
        CurrentActivityExecutionContext.set(context);
        Object result = null;
        try {
            result = this.activity.invoke(this.activitiesImplmentationObject, inputParameters);
        }
        catch (InvocationTargetException invocationException) {
            this.throwActivityFailureException(invocationException.getTargetException() != null ? invocationException.getTargetException() : invocationException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwActivityFailureException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwActivityFailureException(illegalAccessException);
        }
        finally {
            CurrentActivityExecutionContext.unset();
        }
        return this.converter.toData(result);
    }

    public ActivityTypeRegistrationOptions getRegistrationOptions() {
        return this.registrationOptions;
    }

    public ActivityTypeExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    void throwActivityFailureException(Throwable exception) throws ActivityFailureException, CancellationException {
        if (exception instanceof CancellationException) {
            throw (CancellationException)exception;
        }
        String reason = WorkflowExecutionUtils.truncateReason(exception.getMessage());
        String details = null;
        try {
            details = this.converter.toData(exception);
        }
        catch (DataConverterException dataConverterException) {
            if (dataConverterException.getCause() == null) {
                dataConverterException.initCause(exception);
            }
            throw dataConverterException;
        }
        throw new ActivityFailureException(reason, details);
    }

    public Method getMethod() {
        return this.activity;
    }

    public Object getActivitiesImplementation() {
        return this.activitiesImplmentationObject;
    }
}

