/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import java.util.concurrent.CancellationException;

class ActivityExecutionContextImpl
extends ActivityExecutionContext {
    private final AmazonSimpleWorkflow service;
    private final String domain;
    private final ActivityTask task;

    public ActivityExecutionContextImpl(AmazonSimpleWorkflow service, String domain, ActivityTask task) {
        this.domain = domain;
        this.service = service;
        this.task = task;
    }

    public void recordActivityHeartbeat(String details) throws CancellationException {
        RecordActivityTaskHeartbeatRequest r = new RecordActivityTaskHeartbeatRequest();
        r.setTaskToken(this.task.getTaskToken());
        r.setDetails(details);
        ActivityTaskStatus status = this.service.recordActivityTaskHeartbeat(r);
        if (status.isCancelRequested().booleanValue()) {
            throw new CancellationException();
        }
    }

    public ActivityTask getTask() {
        return this.task;
    }

    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public String getTaskToken() {
        return this.task.getTaskToken();
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.task.getWorkflowExecution();
    }

    public String getDomain() {
        return this.domain;
    }
}

