/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecider;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskHandler;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.HistoryHelper;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.Decision;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncDecisionTaskHandler
extends DecisionTaskHandler {
    private static final Log log = LogFactory.getLog(AsyncDecisionTaskHandler.class);
    private static final Log asyncThreadDumpLog = LogFactory.getLog((String)(AsyncDecisionTaskHandler.class.getName() + ".waitingTasksStacks"));
    private final WorkflowDefinitionFactoryFactory definitionFactoryFactory;

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory) {
        this.definitionFactoryFactory = definitionFactoryFactory;
    }

    @Override
    public RespondDecisionTaskCompletedRequest handleDecisionTask(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        DecisionsHelper decisionsHelper = decider.getDecisionsHelper();
        List<Decision> decisions = decisionsHelper.getDecisions();
        String context = decisionsHelper.getWorkflowContextDataToReturn();
        DecisionTask decisionTask = historyHelper.getDecisionTask();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WorkflowTask taskId=" + decisionTask.getStartedEventId() + ", taskToken=" + decisionTask.getTaskToken() + " completed with " + decisions.size() + " new decisions"));
        }
        if (decisions.size() == 0 && asyncThreadDumpLog.isTraceEnabled()) {
            asyncThreadDumpLog.trace((Object)("Empty decision list with the following waiting tasks:\n" + decider.getAsynchronousThreadDumpAsString()));
        }
        RespondDecisionTaskCompletedRequest completedRequest = new RespondDecisionTaskCompletedRequest();
        completedRequest.setTaskToken(decisionTask.getTaskToken());
        completedRequest.setDecisions(decisions);
        completedRequest.setExecutionContext(context);
        return completedRequest;
    }

    @Override
    public WorkflowDefinition loadWorkflowThroughReplay(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        DecisionsHelper decisionsHelper = decider.getDecisionsHelper();
        if (decisionsHelper.isWorkflowFailed()) {
            throw new IllegalStateException("Cannot load failed workflow", decisionsHelper.getWorkflowFailureCause());
        }
        return decider.getWorkflowDefinition();
    }

    @Override
    public List<AsyncTaskInfo> getAsynchronousThreadDump(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        return decider.getAsynchronousThreadDump();
    }

    @Override
    public String getAsynchronousThreadDumpAsString(Iterator<DecisionTask> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        return decider.getAsynchronousThreadDumpAsString();
    }

    private AsyncDecider createDecider(HistoryHelper historyHelper) throws Exception {
        WorkflowDefinitionFactory workflowDefinitionFactory;
        DecisionTask decisionTask = historyHelper.getDecisionTask();
        WorkflowType workflowType = decisionTask.getWorkflowType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WorkflowTask received: taskId=" + decisionTask.getStartedEventId() + ", taskToken=" + decisionTask.getTaskToken() + ", workflowExecution=" + decisionTask.getWorkflowExecution()));
        }
        if ((workflowDefinitionFactory = this.definitionFactoryFactory.getWorkflowDefinitionFactory(workflowType)) == null) {
            log.error((Object)("Received decision task for workflow type not configured with a worker: workflowType=" + decisionTask.getWorkflowType() + ", taskToken=" + decisionTask.getTaskToken() + ", workflowExecution=" + decisionTask.getWorkflowExecution()));
            if (workflowDefinitionFactory == null) {
                throw new IllegalArgumentException("No implementation was found for " + decisionTask.getWorkflowType());
            }
        }
        DecisionsHelper decisionsHelper = new DecisionsHelper(decisionTask);
        AsyncDecider decider = new AsyncDecider(workflowDefinitionFactory, historyHelper, decisionsHelper);
        return decider;
    }
}

