/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowExecutionLocal;

public abstract class CurrentDecisionContext {
    private static final WorkflowExecutionLocal<DecisionContext> CURRENT = new WorkflowExecutionLocal();

    public static DecisionContext get() {
        DecisionContext result = CURRENT.get();
        if (result == null) {
            throw new IllegalStateException("No context found. It means that the method is called outside of the workflow definition code.");
        }
        return result;
    }

    public static boolean isSet() {
        return CURRENT.get() != null;
    }

    public static void set(DecisionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        WorkflowExecutionLocal.before();
        CURRENT.set(context);
    }

    public static void unset() {
        WorkflowExecutionLocal.after();
    }
}

