/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskHandler;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.TaskList;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecisionTaskPoller
implements TaskPoller {
    private static final Log log = LogFactory.getLog(DecisionTaskPoller.class);
    private static final Log decisionsLog = LogFactory.getLog((String)(DecisionTaskPoller.class.getName() + ".decisions"));
    private AmazonSimpleWorkflow service;
    private String domain;
    private String taskListToPoll;
    private String identity;
    private boolean validated;
    private DecisionTaskHandler decisionTaskHandler;

    public DecisionTaskPoller() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
    }

    public DecisionTaskPoller(AmazonSimpleWorkflow service, String domain, String taskListToPoll, DecisionTaskHandler decisionTaskHandler) {
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = taskListToPoll;
        this.decisionTaskHandler = decisionTaskHandler;
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.validated = false;
        this.identity = identity;
    }

    public AmazonSimpleWorkflow getService() {
        return this.service;
    }

    public String getDomain() {
        return this.domain;
    }

    public DecisionTaskHandler getDecisionTaskHandler() {
        return this.decisionTaskHandler;
    }

    public void setDecisionTaskHandler(DecisionTaskHandler decisionTaskHandler) {
        this.validated = false;
        this.decisionTaskHandler = decisionTaskHandler;
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.validated = false;
        this.service = service;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String pollTaskList) {
        this.taskListToPoll = pollTaskList;
    }

    private DecisionTask poll(String nextResultToken) {
        this.validate();
        PollForDecisionTaskRequest pollRequest = new PollForDecisionTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.identity);
        pollRequest.setNextPageToken(nextResultToken);
        pollRequest.setTaskList(new TaskList().withName(this.taskListToPoll));
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request begin: " + pollRequest));
        }
        DecisionTask result = this.service.pollForDecisionTask(pollRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request returned decision task: workflowType=" + result.getWorkflowType() + ", workflowExecution=" + result.getWorkflowExecution() + ", startedEventId=" + result.getStartedEventId() + ", previousStartedEventId=" + result.getPreviousStartedEventId()));
        }
        if (result == null || result.getTaskToken() == null) {
            return null;
        }
        return result;
    }

    public boolean pollAndProcessSingleTask() throws Exception {
        DecisionTaskIterator tasks = null;
        RespondDecisionTaskCompletedRequest taskCompletedRequest = null;
        try {
            tasks = new DecisionTaskIterator();
            if (!tasks.hasNext()) {
                return false;
            }
            taskCompletedRequest = this.decisionTaskHandler.handleDecisionTask(tasks);
            if (decisionsLog.isTraceEnabled()) {
                decisionsLog.trace((Object)WorkflowExecutionUtils.prettyPrintDecisions(taskCompletedRequest.getDecisions()));
            }
            this.service.respondDecisionTaskCompleted(taskCompletedRequest);
        }
        catch (Exception e) {
            if (tasks != null) {
                DecisionTask firstTask = tasks.getFirstDecisionTask();
                if (firstTask != null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("DecisionTask failure: taskId= " + firstTask.getStartedEventId() + ", workflowExecution=" + firstTask.getWorkflowExecution()), (Throwable)e);
                    }
                    if (log.isDebugEnabled() && firstTask.getEvents() != null) {
                        log.debug((Object)("Failed taskId=" + firstTask.getStartedEventId() + " history: " + WorkflowExecutionUtils.prettyPrintHistory(firstTask.getEvents(), true)));
                    }
                }
                if (taskCompletedRequest != null && decisionsLog.isWarnEnabled()) {
                    decisionsLog.warn((Object)("Failed taskId=" + firstTask.getStartedEventId() + " decisions=" + WorkflowExecutionUtils.prettyPrintDecisions(taskCompletedRequest.getDecisions())));
                }
            }
            throw e;
        }
        return true;
    }

    private void validate() throws IllegalStateException {
        if (this.validated) {
            return;
        }
        this.checkFieldSet("decisionTaskHandler", this.decisionTaskHandler);
        this.checkFieldSet("service", this.service);
        this.checkFieldSet("identity", this.identity);
        this.validated = true;
    }

    private void checkFieldSet(String fieldName, Object fieldValue) throws IllegalStateException {
        if (fieldValue == null) {
            throw new IllegalStateException("Required field " + fieldName + " is not set");
        }
    }

    protected void checkFieldNotNegative(String fieldName, long fieldValue) throws IllegalStateException {
        if (fieldValue < 0L) {
            throw new IllegalStateException("Field " + fieldName + " is negative");
        }
    }

    public void shutdown() {
    }

    public void shutdownNow() {
    }

    public boolean awaitTermination(long left, TimeUnit milliseconds) throws InterruptedException {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DecisionTaskIterator
    implements Iterator<DecisionTask> {
        private final DecisionTask firstDecisionTask;
        private DecisionTask next;

        public DecisionTaskIterator() {
            this.next = this.firstDecisionTask = DecisionTaskPoller.this.poll(null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DecisionTask next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("hasNext() == false");
            }
            DecisionTask result = this.next;
            if (this.next.getNextPageToken() == null) {
                this.next = null;
            } else {
                this.next = DecisionTaskPoller.this.poll(this.next.getNextPageToken());
                if (this.firstDecisionTask != result) {
                    this.firstDecisionTask.setEvents(null);
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public DecisionTask getFirstDecisionTask() {
            return this.firstDecisionTask;
        }
    }
}

