/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.ActivityDecisionStateMachine;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.ChildWorkflowDecisionStateMachine;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.CompleteWorkflowStateMachine;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachine;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionTarget;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.SignalDecisionStateMachine;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.TimerDecisionStateMachine;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskCancelRequestedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskCanceledEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskCompletedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskScheduledEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ActivityTaskTimedOutEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.CancelTimerFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.CancelWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ChildWorkflowExecutionStartedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.CompleteWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.Decision;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.DecisionTaskCompletedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.FailWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RequestCancelActivityTaskFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.SignalExternalWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.SignalExternalWorkflowExecutionInitiatedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartChildWorkflowExecutionInitiatedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartTimerDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartTimerFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.TaskList;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.TimerCanceledEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.TimerStartedEventAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DecisionsHelper {
    static final int MAXIMUM_DECISIONS_PER_COMPLETION = 100;
    static final String FORCE_IMMEDIATE_DECISION_TIMER = "FORCE_IMMEDIATE_DECISION";
    private final DecisionTask task;
    private long idCounter;
    private final Map<Long, String> activitySchedulingEventIdToActivityId = new HashMap<Long, String>();
    private final Map<Long, String> signalInitiatedEventIdToSignalId = new HashMap<Long, String>();
    private final Map<DecisionId, DecisionStateMachine> decisions = new LinkedHashMap<DecisionId, DecisionStateMachine>(100, 0.75f, true);
    private Throwable workflowFailureCause;
    private String workflowContextData;
    private String workfowContextFromLastDecisionCompletion;

    DecisionsHelper(DecisionTask task) {
        this.task = task;
    }

    void scheduleActivityTask(ScheduleActivityTaskDecisionAttributes schedule) {
        DecisionId decisionId = new DecisionId(DecisionTarget.ACTIVITY, schedule.getActivityId());
        this.addDecision(decisionId, new ActivityDecisionStateMachine(decisionId, schedule));
    }

    boolean requestCancelActivityTask(String activityId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    boolean handleActivityTaskClosed(String activityId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleActivityTaskScheduled(HistoryEvent event) {
        ActivityTaskScheduledEventAttributes attributes = event.getActivityTaskScheduledEventAttributes();
        String activityId = attributes.getActivityId();
        this.activitySchedulingEventIdToActivityId.put(event.getEventId(), activityId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleInitiatedEvent(event);
        return decision.isDone();
    }

    public boolean handleScheduleActivityTaskFailed(HistoryEvent event) {
        ScheduleActivityTaskFailedEventAttributes attributes = event.getScheduleActivityTaskFailedEventAttributes();
        String activityId = attributes.getActivityId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    boolean handleActivityTaskCancelRequested(HistoryEvent event) {
        ActivityTaskCancelRequestedEventAttributes attributes = event.getActivityTaskCancelRequestedEventAttributes();
        String activityId = attributes.getActivityId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleCancellationInitiatedEvent();
        return decision.isDone();
    }

    public boolean handleActivityTaskCanceled(HistoryEvent event) {
        ActivityTaskCanceledEventAttributes attributes = event.getActivityTaskCanceledEventAttributes();
        String activityId = this.getActivityId(attributes);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleRequestCancelActivityTaskFailed(HistoryEvent event) {
        RequestCancelActivityTaskFailedEventAttributes attributes = event.getRequestCancelActivityTaskFailedEventAttributes();
        String activityId = attributes.getActivityId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleCancellationFailureEvent(event);
        return decision.isDone();
    }

    void startChildWorkflowExecution(StartChildWorkflowExecutionDecisionAttributes schedule) {
        DecisionId decisionId = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, schedule.getWorkflowId());
        this.addDecision(decisionId, new ChildWorkflowDecisionStateMachine(decisionId, schedule));
    }

    void handleStartChildWorkflowExecutionInitiated(HistoryEvent event) {
        StartChildWorkflowExecutionInitiatedEventAttributes attributes = event.getStartChildWorkflowExecutionInitiatedEventAttributes();
        String workflowId = attributes.getWorkflowId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleInitiatedEvent(event);
    }

    public boolean handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        StartChildWorkflowExecutionFailedEventAttributes attributes = event.getStartChildWorkflowExecutionFailedEventAttributes();
        String workflowId = attributes.getWorkflowId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    boolean requestCancelExternalWorkflowExecution(boolean childWorkflow, RequestCancelExternalWorkflowExecutionDecisionAttributes request, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, request.getWorkflowId()));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    void handleRequestCancelExternalWorkflowExecutionInitiated(HistoryEvent event) {
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes attributes = event.getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes();
        String workflowId = attributes.getWorkflowId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleCancellationInitiatedEvent();
    }

    void handleRequestCancelExternalWorkflowExecutionFailed(HistoryEvent event) {
        RequestCancelExternalWorkflowExecutionFailedEventAttributes attributes = event.getRequestCancelExternalWorkflowExecutionFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, attributes.getWorkflowId()));
        decision.handleCancellationFailureEvent(event);
    }

    void signalExternalWorkflowExecution(SignalExternalWorkflowExecutionDecisionAttributes signal) {
        DecisionId decisionId = new DecisionId(DecisionTarget.SIGNAL, signal.getControl());
        this.addDecision(decisionId, new SignalDecisionStateMachine(decisionId, signal));
    }

    void cancelSignalExternalWorkflowExecution(String signalId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.cancel(immediateCancellationCallback);
    }

    void handleSignalExternalWorkflowExecutionInitiated(HistoryEvent event) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes attributes = event.getSignalExternalWorkflowExecutionInitiatedEventAttributes();
        String signalId = attributes.getControl();
        this.signalInitiatedEventIdToSignalId.put(event.getEventId(), signalId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.handleInitiatedEvent(event);
    }

    public boolean handleSignalExternalWorkflowExecutionFailed(String signalId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    public boolean handleExternalWorkflowExecutionSignaled(String signalId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    void startTimer(StartTimerDecisionAttributes request, Object createTimerUserContext) {
        String timerId = request.getTimerId();
        DecisionId decisionId = new DecisionId(DecisionTarget.TIMER, timerId);
        this.addDecision(decisionId, new TimerDecisionStateMachine(decisionId, request));
    }

    boolean cancelTimer(String timerId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, timerId));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    public void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        ChildWorkflowExecutionStartedEventAttributes attributes = event.getChildWorkflowExecutionStartedEventAttributes();
        String workflowId = attributes.getWorkflowExecution().getWorkflowId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleStartedEvent(event);
    }

    boolean handleChildWorkflowExecutionClosed(String workflowId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    public void handleChildWorkflowExecutionCancelRequested(HistoryEvent event) {
    }

    public boolean handleChildWorkflowExecutionCanceled(String workflowId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleTimerClosed(String timerId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, timerId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleTimerStarted(HistoryEvent event) {
        TimerStartedEventAttributes attributes = event.getTimerStartedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.getTimerId()));
        decision.handleInitiatedEvent(event);
        return decision.isDone();
    }

    public boolean handleStartTimerFailed(HistoryEvent event) {
        StartTimerFailedEventAttributes attributes = event.getStartTimerFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.getTimerId()));
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    boolean handleTimerCanceled(HistoryEvent event) {
        TimerCanceledEventAttributes attributes = event.getTimerCanceledEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.getTimerId()));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleCancelTimerFailed(HistoryEvent event) {
        CancelTimerFailedEventAttributes attributes = event.getCancelTimerFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.getTimerId()));
        decision.handleCancellationFailureEvent(event);
        return decision.isDone();
    }

    void completeWorkflowExecution(String output) {
        Decision decision = new Decision();
        CompleteWorkflowExecutionDecisionAttributes complete = new CompleteWorkflowExecutionDecisionAttributes();
        complete.setResult(output);
        decision.setCompleteWorkflowExecutionDecisionAttributes(complete);
        decision.setDecisionType(DecisionType.CompleteWorkflowExecution.toString());
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void continueAsNewWorkflowExecution(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        String taskList;
        ContinueAsNewWorkflowExecutionDecisionAttributes attributes = new ContinueAsNewWorkflowExecutionDecisionAttributes();
        attributes.setWorkflowTypeVersion(continueParameters.getWorkflowTypeVersion());
        ChildPolicy childPolicy = continueParameters.getChildPolicy();
        if (childPolicy != null) {
            attributes.setChildPolicy(childPolicy);
        }
        attributes.setInput(continueParameters.getInput());
        attributes.setExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(continueParameters.getExecutionStartToCloseTimeoutSeconds()));
        attributes.setTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(continueParameters.getTaskStartToCloseTimeoutSeconds()));
        List<String> tagList = continueParameters.getTagList();
        if (tagList != null) {
            attributes.setTagList(tagList);
        }
        if ((taskList = continueParameters.getTaskList()) != null && !taskList.isEmpty()) {
            attributes.setTaskList(new TaskList().withName(taskList));
        }
        Decision decision = new Decision();
        decision.setDecisionType(DecisionType.ContinueAsNewWorkflowExecution.toString());
        decision.setContinueAsNewWorkflowExecutionDecisionAttributes(attributes);
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void failWorkflowExecution(Throwable e) {
        Decision decision = new Decision();
        FailWorkflowExecutionDecisionAttributes fail = this.createFailWorkflowInstanceAttributes(e);
        decision.setFailWorkflowExecutionDecisionAttributes(fail);
        decision.setDecisionType(DecisionType.FailWorkflowExecution.toString());
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
        this.workflowFailureCause = e;
    }

    void failWorkflowDueToUnexpectedError(Throwable e) {
        this.decisions.clear();
        this.failWorkflowExecution(e);
    }

    void handleCompleteWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null));
        decision.handleInitiationFailedEvent(event);
    }

    void handleFailWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null));
        decision.handleInitiationFailedEvent(event);
    }

    void handleCancelWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null));
        decision.handleInitiationFailedEvent(event);
    }

    void handleContinueAsNewWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null));
        decision.handleInitiationFailedEvent(event);
    }

    void cancelWorkflowExecution() {
        Decision decision = new Decision();
        CancelWorkflowExecutionDecisionAttributes cancel = new CancelWorkflowExecutionDecisionAttributes();
        cancel.setDetails(null);
        decision.setCancelWorkflowExecutionDecisionAttributes(cancel);
        decision.setDecisionType(DecisionType.CancelWorkflowExecution.toString());
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    List<Decision> getDecisions() {
        List<Decision> result = new ArrayList<Decision>(101);
        for (DecisionStateMachine decisionStateMachine : this.decisions.values()) {
            Decision decision = decisionStateMachine.getDecision();
            if (decision == null) continue;
            result.add(decision);
        }
        int size = result.size();
        if (size > 100 && !this.isCompletionEvent((Decision)result.get(98))) {
            result = result.subList(0, 99);
            StartTimerDecisionAttributes attributes = new StartTimerDecisionAttributes();
            attributes.setStartToFireTimeout("0");
            attributes.setTimerId(FORCE_IMMEDIATE_DECISION_TIMER);
            Decision d = new Decision();
            d.setStartTimerDecisionAttributes(attributes);
            d.setDecisionType(DecisionType.StartTimer.toString());
            result.add(d);
        }
        return result;
    }

    private boolean isCompletionEvent(Decision decision) {
        DecisionType type = DecisionType.fromValue(decision.getDecisionType());
        switch (type) {
            case CancelWorkflowExecution: 
            case CompleteWorkflowExecution: 
            case FailWorkflowExecution: 
            case ContinueAsNewWorkflowExecution: {
                return true;
            }
        }
        return false;
    }

    public void handleDecisionTaskStartedEvent() {
        int count = 0;
        Iterator<DecisionStateMachine> iterator = this.decisions.values().iterator();
        DecisionStateMachine next = null;
        DecisionStateMachine decisionStateMachine = this.getNextDecision(iterator);
        while (decisionStateMachine != null) {
            next = this.getNextDecision(iterator);
            if (++count == 100 && next != null && !this.isCompletionEvent(next.getDecision())) break;
            decisionStateMachine.handleDecisionTaskStartedEvent();
            decisionStateMachine = next;
        }
        if (next != null && count < 100) {
            next.handleDecisionTaskStartedEvent();
        }
    }

    private DecisionStateMachine getNextDecision(Iterator<DecisionStateMachine> iterator) {
        DecisionStateMachine result = null;
        while (result == null && iterator.hasNext()) {
            result = iterator.next();
            if (result.getDecision() != null) continue;
            result = null;
        }
        return result;
    }

    public String toString() {
        return WorkflowExecutionUtils.prettyPrintDecisions(this.getDecisions());
    }

    boolean isWorkflowFailed() {
        return this.workflowFailureCause != null;
    }

    public Throwable getWorkflowFailureCause() {
        return this.workflowFailureCause;
    }

    String getWorkflowContextData() {
        return this.workflowContextData;
    }

    void setWorkflowContextData(String workflowState) {
        this.workflowContextData = workflowState;
    }

    String getWorkflowContextDataToReturn() {
        if (this.workfowContextFromLastDecisionCompletion == null || !this.workfowContextFromLastDecisionCompletion.equals(this.workflowContextData)) {
            return this.workflowContextData;
        }
        return null;
    }

    void handleDecisionCompletion(DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes) {
        this.workfowContextFromLastDecisionCompletion = decisionTaskCompletedEventAttributes.getExecutionContext();
    }

    DecisionTask getTask() {
        return this.task;
    }

    String getActivityId(ActivityTaskCanceledEventAttributes attributes) {
        Long sourceId = attributes.getScheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getActivityId(ActivityTaskCompletedEventAttributes attributes) {
        Long sourceId = attributes.getScheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getActivityId(ActivityTaskFailedEventAttributes attributes) {
        Long sourceId = attributes.getScheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getActivityId(ActivityTaskTimedOutEventAttributes attributes) {
        Long sourceId = attributes.getScheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getSignalIdFromExternalWorkflowExecutionSignaled(long initiatedEventId) {
        return this.signalInitiatedEventIdToSignalId.get(initiatedEventId);
    }

    private FailWorkflowExecutionDecisionAttributes createFailWorkflowInstanceAttributes(Throwable failure) {
        String details;
        String reason;
        if (failure instanceof WorkflowException) {
            WorkflowException f = (WorkflowException)failure;
            reason = f.getReason();
            details = f.getDetails();
        } else {
            reason = failure.getMessage();
            StringWriter sw = new StringWriter();
            failure.printStackTrace(new PrintWriter(sw));
            details = sw.toString();
        }
        FailWorkflowExecutionDecisionAttributes result = new FailWorkflowExecutionDecisionAttributes();
        result.setReason(WorkflowExecutionUtils.truncateReason(reason));
        result.setDetails(WorkflowExecutionUtils.truncateDetails(details));
        return result;
    }

    void addDecision(DecisionId decisionId, DecisionStateMachine decision) {
        this.decisions.put(decisionId, decision);
    }

    private DecisionStateMachine getDecision(DecisionId decisionId) {
        DecisionStateMachine result = this.decisions.get(decisionId);
        if (result == null) {
            throw new IllegalArgumentException("Unknown " + decisionId + ". The possible causes are " + "nondeterministic workflow definition code or incompatible change in the workflow definition.");
        }
        return result;
    }

    public String getNextId() {
        return String.valueOf(++this.idCounter);
    }
}

