/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.sns.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePlatformEndpointRequestMarshaller
implements Marshaller<Request<CreatePlatformEndpointRequest>, CreatePlatformEndpointRequest> {
    @Override
    public Request<CreatePlatformEndpointRequest> marshall(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        if (createPlatformEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlatformEndpointRequest> request = new DefaultRequest<CreatePlatformEndpointRequest>(createPlatformEndpointRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformEndpoint");
        request.addParameter("Version", "2010-03-31");
        if (createPlatformEndpointRequest.getPlatformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn", StringUtils.fromString(createPlatformEndpointRequest.getPlatformApplicationArn()));
        }
        if (createPlatformEndpointRequest.getToken() != null) {
            request.addParameter("Token", StringUtils.fromString(createPlatformEndpointRequest.getToken()));
        }
        if (createPlatformEndpointRequest.getCustomUserData() != null) {
            request.addParameter("CustomUserData", StringUtils.fromString(createPlatformEndpointRequest.getCustomUserData()));
        }
        if (createPlatformEndpointRequest != null && createPlatformEndpointRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : createPlatformEndpointRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString(attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString(attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

