/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long byteCount = 0L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public int read() throws IOException {
        int tmp = super.read();
        this.byteCount += tmp >= 0 ? 1L : 0L;
        return tmp;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int tmp = super.read(b, off, len);
        this.byteCount += tmp >= 0 ? (long)tmp : 0L;
        return tmp;
    }
}

