/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicy;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Trash
extends Configured {
    private TrashPolicy trashPolicy;

    public Trash(Configuration conf) throws IOException {
        this(FileSystem.get(conf), conf);
    }

    public Trash(FileSystem fs, Configuration conf) throws IOException {
        super(conf);
        this.trashPolicy = TrashPolicy.getInstance(conf, fs, fs.getHomeDirectory());
    }

    public static boolean moveToAppropriateTrash(FileSystem fs, Path p, Configuration conf) throws IOException {
        Path fullyResolvedPath = fs.resolvePath(p);
        Trash trash = new Trash(FileSystem.get(fullyResolvedPath.toUri(), conf), conf);
        boolean success = trash.moveToTrash(fullyResolvedPath);
        if (success) {
            System.out.println("Moved: '" + p + "' to trash at: " + trash.getCurrentTrashDir());
        }
        return success;
    }

    public boolean isEnabled() {
        return this.trashPolicy.isEnabled();
    }

    public boolean moveToTrash(Path path) throws IOException {
        return this.trashPolicy.moveToTrash(path);
    }

    public void checkpoint() throws IOException {
        this.trashPolicy.createCheckpoint();
    }

    public void expunge() throws IOException {
        this.trashPolicy.deleteCheckpoint();
    }

    Path getCurrentTrashDir() {
        return this.trashPolicy.getCurrentTrashDir();
    }

    TrashPolicy getTrashPolicy() {
        return this.trashPolicy;
    }

    public Runnable getEmptier() throws IOException {
        return this.trashPolicy.getEmptier();
    }

    public static void main(String[] args) throws Exception {
        new Trash(new Configuration()).getEmptier().run();
    }
}

