/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFileSystem
extends FileSystem {
    final long creationTime;
    final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
    URI myUri;
    private Path workingDir;
    Configuration config;
    InodeTree<FileSystem> fsState;
    Path homeDir = null;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly; operation=" + operation + "Path=" + p);
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFileSystem.readOnlyMountTable(operation, p.toString());
    }

    private static boolean isValidName(String src) {
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0) continue;
            return false;
        }
        return true;
    }

    private String getUriPath(Path p) {
        this.checkPath(p);
        String s = this.makeAbsolute(p).toUri().getPath();
        if (!ViewFileSystem.isValidName(s)) {
            throw new InvalidPathException("Path part " + s + " from URI" + p + " is not a valid filename.");
        }
        return s;
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    public ViewFileSystem() throws IOException {
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public String getScheme() {
        return "viewfs";
    }

    @Override
    public void initialize(URI theUri, Configuration conf) throws IOException {
        super.initialize(theUri, conf);
        this.setConf(conf);
        this.config = conf;
        String authority = theUri.getAuthority();
        try {
            this.myUri = new URI("viewfs", authority, "/", null, null);
            this.fsState = new InodeTree<FileSystem>(conf, authority){

                @Override
                protected FileSystem getTargetFileSystem(URI uri) throws URISyntaxException, IOException {
                    return new ChRootedFileSystem(uri, ViewFileSystem.this.config);
                }

                @Override
                protected FileSystem getTargetFileSystem(InodeTree.INodeDir<FileSystem> dir) throws URISyntaxException {
                    return new InternalDirOfViewFs(dir, ViewFileSystem.this.creationTime, ViewFileSystem.this.ugi, ViewFileSystem.this.myUri);
                }

                @Override
                protected FileSystem getTargetFileSystem(URI[] mergeFsURIList) throws URISyntaxException, UnsupportedFileSystemException {
                    throw new UnsupportedFileSystemException("mergefs not implemented");
                }
            };
            this.workingDir = this.getHomeDirectory();
        }
        catch (URISyntaxException e) {
            throw new IOException("URISyntax exception: " + theUri);
        }
    }

    ViewFileSystem(URI theUri, Configuration conf) throws IOException {
        this();
        this.initialize(theUri, conf);
    }

    public ViewFileSystem(Configuration conf) throws IOException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    public Path getTrashCanLocation(Path f) throws FileNotFoundException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return res.isInternalDir() ? null : ((FileSystem)res.targetFileSystem).getHomeDirectory();
    }

    @Override
    public String getCanonicalServiceName() {
        return null;
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public Path resolvePath(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((FileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.getUriPath(new_dir);
        this.workingDir = this.makeAbsolute(new_dir);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).append(res.remainingPath, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).create(res.remainingPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }
        return ((FileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public boolean delete(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(fs.getPath()), true);
        return ((FileSystem)res.targetFileSystem).getFileBlockLocations(new ViewFsFileStatus(fs, res.remainingPath), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((FileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return new ViewFsFileStatus(status, this.makeQualified(f));
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((FileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            ChRootedFileSystem targetFs = (ChRootedFileSystem)res.targetFileSystem;
            int i = 0;
            for (FileStatus status : statusLst) {
                String suffix = targetFs.stripOutRoot(status.getPath());
                statusLst[i++] = new ViewFsFileStatus(status, this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix)));
            }
        }
        return statusLst;
    }

    @Override
    public boolean mkdirs(Path dir, FsPermission permission) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath, permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        InodeTree.ResolveResult<FileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }
        InodeTree.ResolveResult<FileSystem> resDst = this.fsState.resolve(this.getUriPath(dst), false);
        if (resDst.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", dst);
        }
        if (resSrc.targetFileSystem != resDst.targetFileSystem) {
            throw new IOException("Renames across Mount points not supported");
        }
        return ((FileSystem)resSrc.targetFileSystem).rename(resSrc.remainingPath, resDst.remainingPath);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setVerifyChecksum(verifyChecksum);
        }
    }

    @Override
    public long getDefaultBlockSize() {
        throw new NotInMountpointException("getDefaultBlockSize");
    }

    @Override
    public short getDefaultReplication() {
        throw new NotInMountpointException("getDefaultReplication");
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        throw new NotInMountpointException("getServerDefaults");
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultBlockSize(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }
    }

    @Override
    public short getDefaultReplication(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultReplication(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getServerDefaults(res.remainingPath);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getContentSummary(res.remainingPath);
    }

    @Override
    public void setWriteChecksum(boolean writeChecksum) {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            ((FileSystem)mount.target.targetFileSystem).setWriteChecksum(writeChecksum);
        }
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        int initialListSize = 0;
        for (InodeTree.MountPoint<FileSystem> im : mountPoints) {
            initialListSize += im.target.targetDirLinkList.length;
        }
        ArrayList result = new ArrayList(initialListSize);
        for (int i = 0; i < mountPoints.size(); ++i) {
            List<Token<?>> tokens = ((FileSystem)mountPoints.get((int)i).target.targetFileSystem).getDelegationTokens(renewer);
            if (tokens == null) continue;
            result.addAll(tokens);
        }
        return result;
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer, Credentials credentials) throws IOException {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        int initialListSize = 0;
        for (InodeTree.MountPoint<FileSystem> im : mountPoints) {
            initialListSize += im.target.targetDirLinkList.length;
        }
        HashSet<String> seenServiceNames = new HashSet<String>();
        ArrayList result = new ArrayList(initialListSize);
        for (int i = 0; i < mountPoints.size(); ++i) {
            String serviceName = ((FileSystem)mountPoints.get((int)i).target.targetFileSystem).getCanonicalServiceName();
            if (serviceName == null || seenServiceNames.contains(serviceName)) continue;
            seenServiceNames.add(serviceName);
            Token<? extends TokenIdentifier> knownToken = credentials.getToken(new Text(serviceName));
            if (knownToken != null) {
                result.add(knownToken);
                continue;
            }
            List<Token<?>> tokens = ((FileSystem)mountPoints.get((int)i).target.targetFileSystem).getDelegationTokens(renewer);
            if (tokens == null) continue;
            result.addAll(tokens);
        }
        return result;
    }

    static class InternalDirOfViewFs
    extends FileSystem {
        final InodeTree.INodeDir<FileSystem> theInternalDir;
        final long creationTime;
        final UserGroupInformation ugi;
        final URI myUri;

        public InternalDirOfViewFs(InodeTree.INodeDir<FileSystem> dir, long cTime, UserGroupInformation ugi, URI uri) throws URISyntaxException {
            this.myUri = uri;
            try {
                this.initialize(this.myUri, new Configuration());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot occur");
            }
            this.theInternalDir = dir;
            this.creationTime = cTime;
            this.ugi = ugi;
        }

        private static void checkPathIsSlash(Path f) throws IOException {
            if (f != InodeTree.SlashPath) {
                throw new IOException("Internal implementation error: expected file name to be /");
            }
        }

        @Override
        public URI getUri() {
            return this.myUri;
        }

        @Override
        public Path getWorkingDirectory() {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public void setWorkingDirectory(Path new_dir) {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("append", f);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws AccessControlException {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }

        @Override
        public boolean delete(Path f) throws AccessControlException, IOException {
            return this.delete(f, true);
        }

        @Override
        public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(fs.getPath());
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            return new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(this.theInternalDir.fullPath).makeQualified(this.myUri, null));
        }

        @Override
        public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            FileStatus[] result = new FileStatus[this.theInternalDir.children.size()];
            int i = 0;
            for (Map.Entry iEntry : this.theInternalDir.children.entrySet()) {
                InodeTree.INode inode = iEntry.getValue();
                if (inode instanceof InodeTree.INodeLink) {
                    InodeTree.INodeLink link = (InodeTree.INodeLink)inode;
                    result[i++] = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], link.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                    continue;
                }
                result[i++] = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public boolean mkdirs(Path dir, FsPermission permission) throws AccessControlException, FileAlreadyExistsException {
            if (this.theInternalDir.isRoot & dir == null) {
                throw new FileAlreadyExistsException("/ already exits");
            }
            if (this.theInternalDir.children.containsKey(dir.toString().substring(1))) {
                return true;
            }
            throw ViewFileSystem.readOnlyMountTable("mkdirs", dir);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public boolean rename(Path src, Path dst) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            InternalDirOfViewFs.checkPathIsSlash(dst);
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setOwner", f);
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setPermission", f);
        }

        @Override
        public boolean setReplication(Path f, short replication) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setReplication", f);
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setTimes", f);
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) {
        }

        @Override
        public FsServerDefaults getServerDefaults(Path f) throws IOException {
            throw new NotInMountpointException(f, "getServerDefaults");
        }

        @Override
        public long getDefaultBlockSize(Path f) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }

        @Override
        public short getDefaultReplication(Path f) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }
    }

    public static class MountPoint {
        private Path src;
        private URI[] targets;

        MountPoint(Path srcPath, URI[] targetURIs) {
            this.src = srcPath;
            this.targets = targetURIs;
        }

        Path getSrc() {
            return this.src;
        }

        URI[] getTargets() {
            return this.targets;
        }
    }
}

