/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public abstract class FCStatisticsBaseTest {
    protected static int blockSize = 512;
    protected static int numBlocks = 1;
    protected static FileContext fc = null;

    @Test
    public void testStatistics() throws IOException, URISyntaxException {
        URI fsUri = this.getFsUri();
        FileSystem.Statistics stats = FileContext.getStatistics((URI)fsUri);
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Path filePath = FileContextTestHelper.getTestRootPath(fc, "file1");
        FileContextTestHelper.createFile(fc, filePath, numBlocks, blockSize);
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        this.verifyWrittenBytes(stats);
        FSDataInputStream fstr = fc.open(filePath);
        byte[] buf = new byte[blockSize];
        int bytesRead = fstr.read(buf, 0, blockSize);
        Assert.assertEquals((long)blockSize, (long)bytesRead);
        this.verifyReadBytes(stats);
        this.verifyWrittenBytes(stats);
        this.verifyReadBytes(FileContext.getStatistics((URI)this.getFsUri()));
        Map statsMap = FileContext.getAllStatistics();
        URI exactUri = this.getSchemeAuthorityUri();
        this.verifyWrittenBytes((FileSystem.Statistics)statsMap.get(exactUri));
        fc.delete(filePath, true);
    }

    protected abstract void verifyReadBytes(FileSystem.Statistics var1);

    protected abstract void verifyWrittenBytes(FileSystem.Statistics var1);

    protected abstract URI getFsUri();

    protected URI getSchemeAuthorityUri() {
        URI uri = this.getFsUri();
        String SchemeAuthString = uri.getScheme() + "://";
        SchemeAuthString = uri.getAuthority() == null ? SchemeAuthString + "/" : SchemeAuthString + uri.getAuthority();
        return URI.create(SchemeAuthString);
    }
}

