/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FileContextCreateMkdirBaseTest {
    protected static FileContext fc;

    public FileContextCreateMkdirBaseTest() {
        try {
            ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.DEBUG);
        }
        catch (Exception e) {
            System.out.println("Cannot change log level\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    @Before
    public void setUp() throws Exception {
        fc.mkdir(FileContextTestHelper.getTestRootPath(fc), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        fc.delete(FileContextTestHelper.getTestRootPath(fc), true);
    }

    @Test
    public void testMkdirNonRecursiveWithExistingDir() throws IOException {
        Path f = FileContextTestHelper.getTestRootPath(fc, "aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, f));
    }

    @Test
    public void testMkdirNonRecursiveWithNonExistingDir() {
        try {
            fc.mkdir(FileContextTestHelper.getTestRootPath(fc, "NonExistant/aDir"), FileContext.DEFAULT_PERM, false);
            Assert.fail((String)"Mkdir with non existing parent dir should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMkdirRecursiveWithExistingDir() throws IOException {
        Path f = FileContextTestHelper.getTestRootPath(fc, "aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, f));
    }

    @Test
    public void testMkdirRecursiveWithNonExistingDir() throws IOException {
        Path f = FileContextTestHelper.getTestRootPath(fc, "NonExistant2/aDir");
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, f));
    }

    @Test
    public void testCreateNonRecursiveWithExistingDir() throws IOException {
        Path f = FileContextTestHelper.getTestRootPath(fc, "foo");
        FileContextTestHelper.createFile(fc, f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(fc, f));
    }

    @Test
    public void testCreateNonRecursiveWithNonExistingDir() {
        try {
            FileContextTestHelper.createFileNonRecursive(fc, FileContextTestHelper.getTestRootPath(fc, "NonExisting/foo"));
            Assert.fail((String)"Create with non existing parent dir should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRecursiveWithExistingDir() throws IOException {
        Path f = FileContextTestHelper.getTestRootPath(fc, "foo");
        FileContextTestHelper.createFile(fc, f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(fc, f));
    }

    @Test
    public void testCreateRecursiveWithNonExistingDir() throws IOException {
        Path f = FileContextTestHelper.getTestRootPath(fc, "NonExisting/foo");
        FileContextTestHelper.createFile(fc, f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(fc, f));
    }
}

