/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FileContextMainOperationsBaseTest {
    private static String TEST_DIR_AAA2 = "test/hadoop2/aaa";
    private static String TEST_DIR_AAA = "test/hadoop/aaa";
    private static String TEST_DIR_AXA = "test/hadoop/axa";
    private static String TEST_DIR_AXX = "test/hadoop/axx";
    private static int numBlocks = 2;
    public static final Path LOCAL_FS_ROOT_PATH;
    protected static FileContext fc;
    private static final PathFilter DEFAULT_FILTER;
    private static final PathFilter TEST_X_FILTER;
    private static byte[] data;

    @Before
    public void setUp() throws Exception {
        fc.mkdir(FileContextTestHelper.getTestRootPath(fc, "test"), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        fc.delete(new Path(FileContextTestHelper.getAbsoluteTestRootPath(fc), new Path("test")), true);
        fc.delete(LOCAL_FS_ROOT_PATH, true);
    }

    protected Path getDefaultWorkingDirectory() throws IOException {
        return FileContextTestHelper.getTestRootPath(fc, "/user/" + System.getProperty("user.name")).makeQualified(fc.getDefaultFileSystem().getUri(), fc.getWorkingDirectory());
    }

    protected boolean renameSupported() {
        return true;
    }

    protected IOException unwrapException(IOException e) {
        return e;
    }

    @Test
    public void testFsStatus() throws Exception {
        FsStatus fsStatus = fc.getFsStatus(null);
        Assert.assertNotNull((Object)fsStatus);
        Assert.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = new Path(FileContextTestHelper.getAbsoluteTestRootPath(fc), new Path("test"));
        fc.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fc.getWorkingDirectory());
        fc.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)workDir, (Object)fc.getWorkingDirectory());
        fc.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)workDir.getParent(), (Object)fc.getWorkingDirectory());
        workDir = new Path(FileContextTestHelper.getAbsoluteTestRootPath(fc), new Path("test"));
        fc.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fc.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        fc.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fc.getWorkingDirectory());
        absoluteDir = FileContextTestHelper.getTestRootPath(fc, "test/existingDir2");
        fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        fc.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fc.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        fc.create(absolutePath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        fc.open(new Path("foo")).close();
        fc.mkdir(new Path("newDir"), FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(fc, new Path(absoluteDir, "newDir")));
        absoluteDir = FileContextTestHelper.getTestRootPath(fc, "nonexistingPath");
        try {
            fc.setWorkingDirectory(absoluteDir);
            Assert.fail((String)"cd to non existing dir should have failed");
        }
        catch (Exception e) {
            // empty catch block
        }
        absoluteDir = new Path(LOCAL_FS_ROOT_PATH, "existingDir");
        fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        fc.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fc.getWorkingDirectory());
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop");
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, testDir));
        fc.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, testDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, testDir));
        fc.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, testDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, testDir));
        Path parentDir = testDir.getParent();
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, parentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, grandparentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(fc, grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop");
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDir));
        fc.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, testDir));
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file"));
        Path testSubDir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file/subdir");
        try {
            fc.mkdir(testSubDir, FsPermission.getDefault(), true);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testSubDir));
        Path testDeepSubDir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file/deep/sub/dir");
        try {
            fc.mkdir(testDeepSubDir, FsPermission.getDefault(), true);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDeepSubDir));
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fc.getFileStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fc.listStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a"), FileContextTestHelper.getTestRootPath(fc, "test/hadoop/b"), FileContextTestHelper.getTestRootPath(fc, "test/hadoop/c/1")};
        Assert.assertFalse((boolean)FileContextTestHelper.exists(fc, testDirs[0]));
        for (Path path : testDirs) {
            fc.mkdir(path, FsPermission.getDefault(), true);
        }
        FileStatus[] paths = fc.util().listStatus(FileContextTestHelper.getTestRootPath(fc, "test"));
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)FileContextTestHelper.getTestRootPath(fc, "test/hadoop"), (Object)paths[0].getPath());
        paths = fc.util().listStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop"));
        Assert.assertEquals((long)3L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/b"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/c"), paths));
        paths = fc.util().listStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a"));
        Assert.assertEquals((long)0L, (long)paths.length);
        RemoteIterator pathsIterator = fc.listStatus(FileContextTestHelper.getTestRootPath(fc, "test"));
        Assert.assertEquals((Object)FileContextTestHelper.getTestRootPath(fc, "test/hadoop"), (Object)((FileStatus)pathsIterator.next()).getPath());
        Assert.assertFalse((boolean)pathsIterator.hasNext());
        pathsIterator = fc.listStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop"));
        FileStatus[] subdirs = new FileStatus[3];
        int i = 0;
        while (i < 3 && pathsIterator.hasNext()) {
            subdirs[i++] = (FileStatus)pathsIterator.next();
        }
        Assert.assertFalse((boolean)pathsIterator.hasNext());
        Assert.assertTrue((i == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a"), subdirs));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/b"), subdirs));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/c"), subdirs));
        pathsIterator = fc.listStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a"));
        Assert.assertFalse((boolean)pathsIterator.hasNext());
    }

    @Test
    public void testListStatusFilterWithNoMatches() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().listStatus(FileContextTestHelper.getTestRootPath(fc, "test"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    public void testListStatusFilterWithSomeMatches() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().listStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusNonExistentFile() throws Exception {
        FileStatus[] paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoopfsdf"));
        Assert.assertNull((Object)paths);
        paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoopfsdf/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
        paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoopfsdf/xyz*/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusWithNoMatchesInPath() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusSomeMatchesInDirectories() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop*"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, "test/hadoop2"), paths));
    }

    @Test
    public void testGlobStatusWithMultipleWildCardMatches() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop*/*"));
        Assert.assertEquals((long)4L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2), paths));
    }

    @Test
    public void testGlobStatusWithMultipleMatchesOfSingleChar() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA2)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] paths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/ax?"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), paths));
    }

    @Test
    public void testGlobStatusFilterWithEmptyPathResults() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/?"), DEFAULT_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithSomePathMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/*"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultipleWildCardMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a??"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathMatchesAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/*"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithNoMatchingPathsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/?"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathWildcardsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AAA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX)};
        if (!FileContextTestHelper.exists(fc, testDirs[0])) {
            for (Path path : testDirs) {
                fc.mkdir(path, FsPermission.getDefault(), true);
            }
        }
        FileStatus[] filteredPaths = fc.util().globStatus(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/a??"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileContextTestHelper.getTestRootPath(fc, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(FileContextTestHelper.getDefaultBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(FileContextTestHelper.getDefaultBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        int blockSize = FileContextTestHelper.getDefaultBlockSize();
        this.writeReadAndDelete(blockSize + blockSize / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(FileContextTestHelper.getDefaultBlockSize() * 2);
    }

    private void writeReadAndDelete(int len) throws IOException {
        Path path = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        fc.mkdir(path.getParent(), FsPermission.getDefault(), true);
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.repFac((short)1), Options.CreateOpts.blockSize((long)FileContextTestHelper.getDefaultBlockSize())});
        out.write(data, 0, len);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileContextTestHelper.exists(fc, path));
        Assert.assertEquals((String)"Length", (long)len, (long)fc.getFileStatus(path).getLen());
        FSDataInputStream in = fc.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assert.assertEquals((long)len, (long)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)data[i], (long)buf[i]);
        }
        Assert.assertTrue((String)"Deleted", (boolean)fc.delete(path, false));
        Assert.assertFalse((String)"No longer exists", (boolean)FileContextTestHelper.exists(fc, path));
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testNullCreateFlag() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/file");
        fc.create(p, null, new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testEmptyCreateFlag() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/file");
        fc.create(p, EnumSet.noneOf(CreateFlag.class), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFlagCreateExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagCreateExistingFile");
        this.createFile(p);
        fc.create(p, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=FileNotFoundException.class)
    public void testCreateFlagOverwriteNonExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagOverwriteNonExistingFile");
        fc.create(p, EnumSet.of(CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test
    public void testCreateFlagOverwriteExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagOverwriteExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test(expected=FileNotFoundException.class)
    public void testCreateFlagAppendNonExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagAppendNonExistingFile");
        fc.create(p, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test
    public void testCreateFlagAppendExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagAppendExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, 2 * data.length);
    }

    @Test
    public void testCreateFlagCreateAppendNonExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagCreateAppendNonExistingFile");
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, data.length);
    }

    @Test
    public void testCreateFlagCreateAppendExistingFile() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/testCreateFlagCreateAppendExistingFile");
        this.createFile(p);
        FSDataOutputStream out = fc.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND), new Options.CreateOpts[0]);
        FileContextMainOperationsBaseTest.writeData(fc, p, out, data, 2 * data.length);
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testCreateFlagAppendOverwrite() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/nonExistent");
        fc.create(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testCreateFlagAppendCreateOverwrite() throws IOException {
        Path p = FileContextTestHelper.getTestRootPath(fc, "test/nonExistent");
        fc.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
        Assert.fail((String)"Excepted exception not thrown");
    }

    private static void writeData(FileContext fc, Path p, FSDataOutputStream out, byte[] data, long expectedLen) throws IOException {
        out.write(data, 0, data.length);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileContextTestHelper.exists(fc, p));
        Assert.assertEquals((String)"Length", (long)expectedLen, (long)fc.getFileStatus(p).getLen());
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        Assert.assertFalse((String)"Parent doesn't exist", (boolean)FileContextTestHelper.exists(fc, path.getParent()));
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FileContextTestHelper.exists(fc, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fc.getFileStatus(path).getLen());
        Assert.assertTrue((String)"Parent exists", (boolean)FileContextTestHelper.exists(fc, path.getParent()));
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        Assert.assertFalse((String)"Doesn't exist", (boolean)FileContextTestHelper.exists(fc, path));
        Assert.assertFalse((String)"No deletion", (boolean)fc.delete(path, true));
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop");
        Path file = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        Path subdir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/subdir");
        this.createFile(file);
        fc.mkdir(subdir, FsPermission.getDefault(), true);
        Assert.assertTrue((String)"File exists", (boolean)FileContextTestHelper.exists(fc, file));
        Assert.assertTrue((String)"Dir exists", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertTrue((String)"Subdir exists", (boolean)FileContextTestHelper.exists(fc, subdir));
        try {
            fc.delete(dir, false);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertTrue((String)"File still exists", (boolean)FileContextTestHelper.exists(fc, file));
        Assert.assertTrue((String)"Dir still exists", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertTrue((String)"Subdir still exists", (boolean)FileContextTestHelper.exists(fc, subdir));
        Assert.assertTrue((String)"Deleted", (boolean)fc.delete(dir, true));
        Assert.assertFalse((String)"File doesn't exist", (boolean)FileContextTestHelper.exists(fc, file));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertFalse((String)"Subdir doesn't exist", (boolean)FileContextTestHelper.exists(fc, subdir));
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = FileContextTestHelper.getTestRootPath(fc, "test/hadoop");
        fc.mkdir(dir, FsPermission.getDefault(), true);
        Assert.assertTrue((String)"Dir exists", (boolean)FileContextTestHelper.exists(fc, dir));
        Assert.assertTrue((String)"Deleted", (boolean)fc.delete(dir, false));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileContextTestHelper.exists(fc, dir));
    }

    @Test
    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/nonExistent");
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/newpath");
        try {
            this.rename(src, dst, false, false, false, Options.Rename.NONE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, false, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/nonExistent/newfile");
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToDestinationWithParentFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/parentFile/newfile");
        this.createFile(dst.getParent());
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileToExistingParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/newfile");
        fc.mkdir(dst.getParent(), FileContext.DEFAULT_PERM, true);
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
    }

    @Test
    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/existingFile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/existingDir");
        fc.mkdir(dst, FileContext.DEFAULT_PERM, true);
        try {
            this.rename(src, dst, false, false, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, false, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
    }

    @Test
    public void testRenameDirectoryToNonExistentParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/nonExistent/newdir");
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameDirectoryAsNonExistentDirectory() throws Exception {
        this.testRenameDirectoryAsNonExistentDirectory(Options.Rename.NONE);
        this.tearDown();
        this.testRenameDirectoryAsNonExistentDirectory(Options.Rename.OVERWRITE);
    }

    private void testRenameDirectoryAsNonExistentDirectory(Options.Rename ... options) throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/file1"));
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/subdir/file2"));
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/newdir");
        fc.mkdir(dst.getParent(), FileContext.DEFAULT_PERM, true);
        this.rename(src, dst, true, false, true, options);
        Assert.assertFalse((String)"Nested file1 exists", (boolean)FileContextTestHelper.exists(fc, FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/file1")));
        Assert.assertFalse((String)"Nested file2 exists", (boolean)FileContextTestHelper.exists(fc, FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/subdir/file2")));
        Assert.assertTrue((String)"Renamed nested file1 exists", (boolean)FileContextTestHelper.exists(fc, FileContextTestHelper.getTestRootPath(fc, "test/new/newdir/file1")));
        Assert.assertTrue((String)"Renamed nested exists", (boolean)FileContextTestHelper.exists(fc, FileContextTestHelper.getTestRootPath(fc, "test/new/newdir/subdir/file2")));
    }

    @Test
    public void testRenameDirectoryAsEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/file1"));
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/subdir/file2"));
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/newdir");
        fc.mkdir(dst, FileContext.DEFAULT_PERM, true);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameDirectoryAsNonEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/file1"));
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir/subdir/file2"));
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/newdir");
        fc.mkdir(dst, FileContext.DEFAULT_PERM, true);
        this.createFile(FileContextTestHelper.getTestRootPath(fc, "test/new/newdir/file1"));
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryAsFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/dir");
        fc.mkdir(src, FileContext.DEFAULT_PERM, true);
        Path dst = FileContextTestHelper.getTestRootPath(fc, "test/new/newfile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = fc.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = FileContextTestHelper.getTestRootPath(fc, "test/hadoop/file");
        FSDataOutputStream out = fc.create(src, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.writeChar(72);
        out.close();
        out.close();
    }

    @Test
    public void testUnsupportedSymlink() throws IOException {
        Path file = FileContextTestHelper.getTestRootPath(fc, "file");
        Path link = FileContextTestHelper.getTestRootPath(fc, "linkToFile");
        if (!fc.getDefaultFileSystem().supportsSymlinks()) {
            try {
                fc.createSymlink(file, link, false);
                Assert.fail((String)"Created a symlink on a file system that does not support symlinks.");
            }
            catch (IOException e) {
                // empty catch block
            }
            this.createFile(file);
            try {
                fc.getLinkTarget(file);
                Assert.fail((String)"Got a link target on a file system that does not support symlinks.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Assert.assertEquals((Object)fc.getFileStatus(file), (Object)fc.getFileLinkStatus(file));
        }
    }

    protected void createFile(Path path) throws IOException {
        FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.write(data, 0, data.length);
        out.close();
    }

    private void rename(Path src, Path dst, boolean renameShouldSucceed, boolean srcExists, boolean dstExists, Options.Rename ... options) throws IOException {
        fc.rename(src, dst, options);
        if (!renameShouldSucceed) {
            Assert.fail((String)"rename should have thrown exception");
        }
        Assert.assertEquals((String)"Source exists", (Object)srcExists, (Object)FileContextTestHelper.exists(fc, src));
        Assert.assertEquals((String)"Destination exists", (Object)dstExists, (Object)FileContextTestHelper.exists(fc, dst));
    }

    private boolean containsPath(Path path, FileStatus[] filteredPaths) throws IOException {
        for (int i = 0; i < filteredPaths.length; ++i) {
            if (!FileContextTestHelper.getTestRootPath(fc, path.toString()).equals((Object)filteredPaths[i].getPath())) continue;
            return true;
        }
        return false;
    }

    static {
        File testBuildData = new File(System.getProperty("test.build.data", "build/test/data"));
        Path localFsRootPath = new Path(testBuildData.getAbsolutePath(), "root-uri");
        LOCAL_FS_ROOT_PATH = localFsRootPath.makeQualified(LocalFileSystem.NAME, null);
        DEFAULT_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return true;
            }
        };
        TEST_X_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().contains("x") || file.getName().contains("X");
            }
        };
        data = FileContextTestHelper.getFileData(numBlocks, FileContextTestHelper.getDefaultBlockSize());
    }
}

