/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FileContextPermissionBase {
    protected static FileContext fc;
    static final FsPermission FILE_MASK_ZERO;

    public FileContextPermissionBase() {
        try {
            ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.DEBUG);
        }
        catch (Exception e) {
            System.out.println("Cannot change log level\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    @Before
    public void setUp() throws Exception {
        fc.mkdir(FileContextTestHelper.getTestRootPath(fc), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        fc.delete(FileContextTestHelper.getTestRootPath(fc), true);
    }

    private void cleanupFile(FileContext fc, Path name) throws IOException {
        junit.framework.Assert.assertTrue((boolean)FileContextTestHelper.exists(fc, name));
        fc.delete(name, true);
        junit.framework.Assert.assertTrue((!FileContextTestHelper.exists(fc, name) ? 1 : 0) != 0);
    }

    @Test
    public void testCreatePermission() throws IOException {
        if (Path.WINDOWS) {
            System.out.println("Cannot run test for Windows");
            return;
        }
        String filename = "foo";
        Path f = FileContextTestHelper.getTestRootPath(fc, filename);
        FileContextTestHelper.createFile(fc, filename);
        this.doFilePermissionCheck(FileContext.DEFAULT_PERM.applyUMask(fc.getUMask()), fc.getFileStatus(f).getPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPermission() throws IOException {
        if (Path.WINDOWS) {
            System.out.println("Cannot run test for Windows");
            return;
        }
        String filename = "foo";
        Path f = FileContextTestHelper.getTestRootPath(fc, filename);
        FileContextTestHelper.createFile(fc, f);
        try {
            FsPermission all = new FsPermission(511);
            FsPermission none = new FsPermission(0);
            fc.setPermission(f, none);
            this.doFilePermissionCheck(none, fc.getFileStatus(f).getPermission());
            fc.setPermission(f, all);
            this.doFilePermissionCheck(all, fc.getFileStatus(f).getPermission());
        }
        finally {
            this.cleanupFile(fc, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwner() throws IOException {
        if (Path.WINDOWS) {
            System.out.println("Cannot run test for Windows");
            return;
        }
        String filename = "bar";
        Path f = FileContextTestHelper.getTestRootPath(fc, filename);
        FileContextTestHelper.createFile(fc, f);
        List<String> groups = null;
        try {
            groups = FileContextPermissionBase.getGroups();
            System.out.println(filename + ": " + fc.getFileStatus(f).getPermission());
        }
        catch (IOException e) {
            System.out.println(StringUtils.stringifyException((Throwable)e));
            System.out.println("Cannot run test");
            return;
        }
        if (groups == null || groups.size() < 1) {
            System.out.println("Cannot run test: need at least one group.  groups=" + groups);
            return;
        }
        try {
            String g0 = groups.get(0);
            fc.setOwner(f, null, g0);
            junit.framework.Assert.assertEquals((String)g0, (String)fc.getFileStatus(f).getGroup());
            if (groups.size() > 1) {
                String g1 = groups.get(1);
                fc.setOwner(f, null, g1);
                junit.framework.Assert.assertEquals((String)g1, (String)fc.getFileStatus(f).getGroup());
            } else {
                System.out.println("Not testing changing the group since user belongs to only one group.");
            }
        }
        finally {
            this.cleanupFile(fc, f);
        }
    }

    @Test
    public void testUgi() throws IOException, InterruptedException {
        UserGroupInformation otherUser = UserGroupInformation.createRemoteUser((String)"otherUser");
        FileContext newFc = (FileContext)otherUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileContext>(){

            @Override
            public FileContext run() throws Exception {
                FileContext newFc = FileContext.getFileContext();
                return newFc;
            }
        });
        Assert.assertEquals((Object)"otherUser", (Object)newFc.getUgi().getUserName());
    }

    static List<String> getGroups() throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        String s = Shell.execCommand((String[])Shell.getGroupsCommand());
        StringTokenizer t = new StringTokenizer(s);
        while (t.hasMoreTokens()) {
            a.add(t.nextToken());
        }
        return a;
    }

    void doFilePermissionCheck(FsPermission expectedPerm, FsPermission actualPerm) {
        junit.framework.Assert.assertEquals((Object)expectedPerm.applyUMask(this.getFileMask()), (Object)actualPerm);
    }

    FsPermission getFileMask() {
        return FILE_MASK_ZERO;
    }

    static {
        FILE_MASK_ZERO = new FsPermission(0);
    }
}

