/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Set;
import junit.framework.Assert;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ShutdownHookManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFileContextDeleteOnExit {
    private static int blockSize = 1024;
    private static int numBlocks = 2;
    private FileContext fc;

    @Before
    public void setup() throws IOException {
        this.fc = FileContext.getLocalFSFileContext();
    }

    @After
    public void tearDown() throws IOException {
        this.fc.delete(FileContextTestHelper.getTestRootPath(this.fc), true);
    }

    private void checkDeleteOnExitData(int size, FileContext fc, Path ... paths) {
        Assert.assertEquals((int)size, (int)FileContext.DELETE_ON_EXIT.size());
        Set set = (Set)FileContext.DELETE_ON_EXIT.get(fc);
        Assert.assertEquals((int)paths.length, (int)(set == null ? 0 : set.size()));
        for (Path path : paths) {
            Assert.assertTrue((boolean)set.contains(path));
        }
    }

    @Test
    public void testDeleteOnExit() throws Exception {
        Path file1 = FileContextTestHelper.getTestRootPath(this.fc, "file1");
        FileContextTestHelper.createFile(this.fc, file1, numBlocks, blockSize);
        this.fc.deleteOnExit(file1);
        this.checkDeleteOnExitData(1, this.fc, file1);
        Assert.assertTrue((boolean)ShutdownHookManager.get().hasShutdownHook((Runnable)FileContext.FINALIZER));
        Path file2 = FileContextTestHelper.getTestRootPath(this.fc, "dir1/file2");
        FileContextTestHelper.createFile(this.fc, file2, numBlocks, blockSize);
        this.fc.deleteOnExit(file2);
        this.checkDeleteOnExitData(1, this.fc, file1, file2);
        Path dir = FileContextTestHelper.getTestRootPath(this.fc, "dir3/dir4/dir5/dir6");
        FileContextTestHelper.createFile(this.fc, dir, numBlocks, blockSize);
        this.fc.deleteOnExit(dir);
        this.checkDeleteOnExitData(1, this.fc, file1, file2, dir);
        FileContext.FINALIZER.run();
        this.checkDeleteOnExitData(0, this.fc, new Path[0]);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, file1));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, file2));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, dir));
    }
}

