/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class TestFileStatus {
    private static final Log LOG = LogFactory.getLog(TestFileStatus.class);

    @Test
    public void testFileStatusWritable() throws Exception {
        FileStatus[] tests = new FileStatus[]{new FileStatus(1L, false, 5, 3L, 4L, 5L, null, "", "", new Path("/a/b")), new FileStatus(0L, false, 1, 2L, 3L, new Path("/")), new FileStatus(1L, false, 5, 3L, 4L, 5L, null, "", "", new Path("/a/b"))};
        LOG.info((Object)"Writing FileStatuses to a ByteArrayOutputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        for (FileStatus fs : tests) {
            fs.write((DataOutput)out);
        }
        LOG.info((Object)"Creating ByteArrayInputStream object");
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        LOG.info((Object)"Testing if read objects are equal to written ones");
        FileStatus dest = new FileStatus();
        int iterator = 0;
        for (FileStatus fs : tests) {
            dest.readFields((DataInput)in);
            Assert.assertEquals((String)("Different FileStatuses in iteration " + iterator), (Object)dest, (Object)fs);
            ++iterator;
        }
    }
}

