/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFsShellCopy {
    static Configuration conf;
    static FsShell shell;
    static LocalFileSystem lfs;
    static Path testRootDir;
    static Path srcPath;
    static Path dstPath;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        testRootDir = lfs.makeQualified(new Path(System.getProperty("test.build.data", "test/build/data"), "testShellCopy"));
        lfs.mkdirs(testRootDir);
        srcPath = new Path(testRootDir, "srcFile");
        dstPath = new Path(testRootDir, "dstFile");
    }

    @Before
    public void prepFiles() throws Exception {
        lfs.setVerifyChecksum(true);
        lfs.setWriteChecksum(true);
        lfs.delete(srcPath, true);
        lfs.delete(dstPath, true);
        FSDataOutputStream out = lfs.create(srcPath);
        out.writeChars("hi");
        out.close();
        Assert.assertTrue((boolean)lfs.exists(lfs.getChecksumFile(srcPath)));
    }

    @Test
    public void testCopyNoCrc() throws Exception {
        this.shellRun(0, "-get", srcPath.toString(), dstPath.toString());
        this.checkPath(dstPath, false);
    }

    @Test
    public void testCopyCrc() throws Exception {
        this.shellRun(0, "-get", "-crc", srcPath.toString(), dstPath.toString());
        this.checkPath(dstPath, true);
    }

    @Test
    public void testCorruptedCopyCrc() throws Exception {
        FSDataOutputStream out = lfs.getRawFileSystem().create(srcPath);
        out.writeChars("bang");
        out.close();
        this.shellRun(1, "-get", srcPath.toString(), dstPath.toString());
    }

    @Test
    public void testCorruptedCopyIgnoreCrc() throws Exception {
        this.shellRun(0, "-get", "-ignoreCrc", srcPath.toString(), dstPath.toString());
        this.checkPath(dstPath, false);
    }

    private void checkPath(Path p, boolean expectChecksum) throws IOException {
        Assert.assertTrue((boolean)lfs.exists(p));
        boolean hasChecksum = lfs.exists(lfs.getChecksumFile(p));
        Assert.assertEquals((Object)expectChecksum, (Object)hasChecksum);
    }

    private void shellRun(int n, String ... args) throws Exception {
        Assert.assertEquals((long)n, (long)shell.run(args));
    }

    @Test
    public void testCopyFileFromLocal() throws Exception {
        Path testRoot = new Path(testRootDir, "testPutFile");
        lfs.delete(testRoot, true);
        lfs.mkdirs(testRoot);
        Path targetDir = new Path(testRoot, "target");
        Path filePath = new Path(testRoot, new Path("srcFile"));
        lfs.create(filePath).close();
        this.checkPut(filePath, targetDir);
    }

    @Test
    public void testCopyDirFromLocal() throws Exception {
        Path testRoot = new Path(testRootDir, "testPutDir");
        lfs.delete(testRoot, true);
        lfs.mkdirs(testRoot);
        Path targetDir = new Path(testRoot, "target");
        Path dirPath = new Path(testRoot, new Path("srcDir"));
        lfs.mkdirs(dirPath);
        lfs.create(new Path(dirPath, "srcFile")).close();
        this.checkPut(dirPath, targetDir);
    }

    private void checkPut(Path srcPath, Path targetDir) throws Exception {
        lfs.delete(targetDir, true);
        lfs.mkdirs(targetDir);
        lfs.setWorkingDirectory(targetDir);
        Path dstPath = new Path("path");
        Path childPath = new Path(dstPath, "childPath");
        lfs.setWorkingDirectory(targetDir);
        this.prepPut(dstPath, false, false);
        this.checkPut(0, srcPath, dstPath);
        if (lfs.isFile(srcPath)) {
            this.checkPut(1, srcPath, dstPath);
        } else {
            this.prepPut(dstPath, true, true);
            this.checkPut(0, srcPath, dstPath);
        }
        this.prepPut(childPath, false, false);
        this.checkPut(1, srcPath, dstPath);
        this.prepPut(dstPath, true, true);
        this.checkPut(0, srcPath, dstPath);
        this.prepPut(childPath, true, true);
        this.checkPut(0, srcPath, childPath);
        this.prepPut(targetDir, true, true);
        this.checkPut(0, srcPath, null);
        this.prepPut(targetDir, true, true);
        this.checkPut(0, srcPath, new Path("."));
        this.prepPut(dstPath, false, true);
        lfs.setWorkingDirectory(dstPath);
        this.checkPut(1, srcPath, null);
        this.prepPut(dstPath, false, true);
        this.checkPut(1, srcPath, new Path("."));
    }

    private void prepPut(Path dst, boolean create, boolean isDir) throws IOException {
        lfs.delete(dst, true);
        Assert.assertFalse((boolean)lfs.exists(dst));
        if (create) {
            if (isDir) {
                lfs.mkdirs(dst);
                Assert.assertTrue((boolean)lfs.isDirectory(dst));
            } else {
                lfs.mkdirs(new Path(dst.getName()));
                lfs.create(dst).close();
                Assert.assertTrue((boolean)lfs.isFile(dst));
            }
        }
    }

    private void checkPut(int exitCode, Path src, Path dest) throws Exception {
        String[] argv = null;
        if (dest != null) {
            argv = new String[]{"-put", src.toString(), this.pathAsString(dest)};
        } else {
            argv = new String[]{"-put", src.toString()};
            dest = new Path(".");
        }
        Path target = lfs.exists(dest) ? (lfs.isDirectory(dest) ? new Path(this.pathAsString(dest), src.getName()) : dest) : new Path(lfs.getWorkingDirectory(), dest);
        boolean targetExists = lfs.exists(target);
        Path parent = lfs.makeQualified(target).getParent();
        System.out.println("COPY src[" + src.getName() + "] -> [" + dest + "] as [" + target + "]");
        String[] lsArgv = new String[]{"-ls", "-R", this.pathAsString(parent)};
        shell.run(lsArgv);
        int gotExit = shell.run(argv);
        System.out.println("copy exit:" + gotExit);
        lsArgv = new String[]{"-ls", "-R", this.pathAsString(parent)};
        shell.run(lsArgv);
        if (exitCode == 0) {
            Assert.assertTrue((boolean)lfs.exists(target));
            Assert.assertTrue((lfs.isFile(src) == lfs.isFile(target) ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)lfs.listStatus(lfs.makeQualified(target).getParent()).length);
        } else {
            Assert.assertEquals((Object)targetExists, (Object)lfs.exists(target));
        }
        Assert.assertEquals((long)exitCode, (long)gotExit);
    }

    @Test
    public void testRepresentsDir() throws Exception {
        Path subdirDstPath = new Path(dstPath, srcPath.getName());
        String[] argv = null;
        lfs.delete(dstPath, true);
        Assert.assertFalse((boolean)lfs.exists(dstPath));
        argv = new String[]{"-put", srcPath.toString(), dstPath.toString()};
        Assert.assertEquals((long)0L, (long)shell.run(argv));
        Assert.assertTrue((lfs.exists(dstPath) && lfs.isFile(dstPath) ? 1 : 0) != 0);
        lfs.delete(dstPath, true);
        Assert.assertFalse((boolean)lfs.exists(dstPath));
        lfs.delete(dstPath, true);
        for (String suffix : new String[]{"/", "/."}) {
            argv = new String[]{"-put", srcPath.toString(), dstPath.toString() + suffix};
            Assert.assertEquals((long)1L, (long)shell.run(argv));
            Assert.assertFalse((boolean)lfs.exists(dstPath));
            Assert.assertFalse((boolean)lfs.exists(subdirDstPath));
        }
        for (String suffix : new String[]{"/", "/."}) {
            lfs.delete(dstPath, true);
            lfs.mkdirs(dstPath);
            argv = new String[]{"-put", srcPath.toString(), dstPath.toString() + suffix};
            Assert.assertEquals((long)0L, (long)shell.run(argv));
            Assert.assertTrue((boolean)lfs.exists(subdirDstPath));
            Assert.assertTrue((boolean)lfs.isFile(subdirDstPath));
        }
        String dotdotDst = dstPath + "/foo/..";
        lfs.delete(dstPath, true);
        lfs.mkdirs(new Path(dstPath, "foo"));
        argv = new String[]{"-put", srcPath.toString(), dotdotDst};
        Assert.assertEquals((long)0L, (long)shell.run(argv));
        Assert.assertTrue((boolean)lfs.exists(subdirDstPath));
        Assert.assertTrue((boolean)lfs.isFile(subdirDstPath));
    }

    @Test
    public void testCopyMerge() throws Exception {
        Path root = new Path(testRootDir, "TestMerge");
        Path f1 = new Path(root, "f1");
        Path f2 = new Path(root, "f2");
        Path f3 = new Path(root, "f3");
        Path fnf = new Path(root, "fnf");
        Path d = new Path(root, "dir");
        Path df1 = new Path(d, "df1");
        Path df2 = new Path(d, "df2");
        Path df3 = new Path(d, "df3");
        this.createFile(f1, f2, f3, df1, df2, df3);
        int exit = shell.run(new String[]{"-getmerge", f1.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f1", (Object)this.readFile("out"));
        exit = shell.run(new String[]{"-getmerge", fnf.toString(), "out"});
        Assert.assertEquals((long)1L, (long)exit);
        Assert.assertFalse((boolean)lfs.exists(new Path("out")));
        exit = shell.run(new String[]{"-getmerge", f1.toString(), f2.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f1f2", (Object)this.readFile("out"));
        exit = shell.run(new String[]{"-getmerge", f2.toString(), f1.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f2f1", (Object)this.readFile("out"));
        exit = shell.run(new String[]{"-getmerge", "-nl", f1.toString(), f2.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f1\nf2\n", (Object)this.readFile("out"));
        shell.run(new String[]{"-getmerge", "-nl", new Path(root, "f*").toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f1\nf2\nf3\n", (Object)this.readFile("out"));
        shell.run(new String[]{"-getmerge", "-nl", root.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f1\nf2\nf3\n", (Object)this.readFile("out"));
        shell.run(new String[]{"-getmerge", "-nl", d.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"df1\ndf2\ndf3\n", (Object)this.readFile("out"));
        shell.run(new String[]{"-getmerge", "-nl", f1.toString(), d.toString(), f2.toString(), "out"});
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"f1\ndf1\ndf2\ndf3\nf2\n", (Object)this.readFile("out"));
    }

    private void createFile(Path ... paths) throws IOException {
        for (Path path : paths) {
            FSDataOutputStream out = lfs.create(path);
            out.write(path.getName().getBytes());
            out.close();
        }
    }

    private String readFile(String out) throws IOException {
        Path path = new Path(out);
        FileStatus stat = lfs.getFileStatus(path);
        FSDataInputStream in = lfs.open(path);
        byte[] buffer = new byte[(int)stat.getLen()];
        in.readFully(buffer);
        in.close();
        lfs.delete(path, false);
        return new String(buffer);
    }

    private String pathAsString(Path p) {
        String s = p == null ? "." : p.toString();
        return s.isEmpty() ? "." : s;
    }
}

