/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFsShellReturnCode {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.TestFsShellReturnCode");
    private static final Configuration conf = new Configuration();
    private static FileSystem fileSys;
    private static FsShell fsShell;
    private static String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        conf.setClass("fs.file.impl", LocalFileSystemExtn.class, LocalFileSystem.class);
        fileSys = FileSystem.get((Configuration)conf);
        fsShell = new FsShell(conf);
    }

    static void writeFile(FileSystem fs, Path name) throws Exception {
        FSDataOutputStream stm = fs.create(name);
        stm.writeBytes("42\n");
        stm.close();
    }

    private void change(int exit, String owner, String group, String ... files) throws Exception {
        FileStatus[][] oldStats = new FileStatus[files.length][];
        for (int i = 0; i < files.length; ++i) {
            oldStats[i] = fileSys.globStatus(new Path(files[i]));
        }
        LinkedList<String> argv = new LinkedList<String>();
        if (owner != null) {
            argv.add("-chown");
            String chown = owner;
            if (group != null) {
                chown = chown + ":" + group;
                if (group.isEmpty()) {
                    group = null;
                }
            }
            argv.add(chown);
        } else {
            argv.add("-chgrp");
            argv.add(group);
        }
        Collections.addAll(argv, files);
        Assert.assertEquals((long)exit, (long)fsShell.run(argv.toArray(new String[0])));
        for (int i = 0; i < files.length; ++i) {
            FileStatus[] stats = fileSys.globStatus(new Path(files[i]));
            if (stats == null) continue;
            for (int j = 0; j < stats.length; ++j) {
                Assert.assertEquals((String)("check owner of " + files[i]), (Object)(owner != null ? "STUB-" + owner : oldStats[i][j].getOwner()), (Object)stats[j].getOwner());
                Assert.assertEquals((String)("check group of " + files[i]), (Object)(group != null ? "STUB-" + group : oldStats[i][j].getGroup()), (Object)stats[j].getGroup());
            }
        }
    }

    @Test
    public void testChmod() throws Exception {
        String f1 = TEST_ROOT_DIR + "/" + "testChmod/fileExists";
        String f2 = TEST_ROOT_DIR + "/" + "testChmod/fileDoesNotExist";
        String f3 = TEST_ROOT_DIR + "/" + "testChmod/nonExistingfiles*";
        Path p1 = new Path(f1);
        Path p4 = new Path(TEST_ROOT_DIR + "/" + "testChmod/file1");
        Path p5 = new Path(TEST_ROOT_DIR + "/" + "testChmod/file2");
        Path p6 = new Path(TEST_ROOT_DIR + "/" + "testChmod/file3");
        String f7 = TEST_ROOT_DIR + "/" + "testChmod/file*";
        TestFsShellReturnCode.writeFile(fileSys, p1);
        Assert.assertTrue((boolean)fileSys.exists(p1));
        String[] argv = new String[]{"-chmod", "777", f1};
        Assert.assertEquals((long)0L, (long)fsShell.run(argv));
        String[] argv2 = new String[]{"-chmod", "777", f2};
        Assert.assertEquals((long)1L, (long)fsShell.run(argv2));
        String[] argv3 = new String[]{"-chmod", "777", f3};
        Assert.assertEquals((long)1L, (long)fsShell.run(argv3));
        TestFsShellReturnCode.writeFile(fileSys, p4);
        Assert.assertTrue((boolean)fileSys.exists(p4));
        TestFsShellReturnCode.writeFile(fileSys, p5);
        Assert.assertTrue((boolean)fileSys.exists(p5));
        TestFsShellReturnCode.writeFile(fileSys, p6);
        Assert.assertTrue((boolean)fileSys.exists(p6));
        String[] argv4 = new String[]{"-chmod", "777", f7};
        Assert.assertEquals((long)0L, (long)fsShell.run(argv4));
    }

    @Test
    public void testChown() throws Exception {
        String f1 = TEST_ROOT_DIR + "/" + "testChown/fileExists";
        String f2 = TEST_ROOT_DIR + "/" + "testChown/fileDoesNotExist";
        String f3 = TEST_ROOT_DIR + "/" + "testChown/nonExistingfiles*";
        Path p1 = new Path(f1);
        Path p4 = new Path(TEST_ROOT_DIR + "/" + "testChown/file1");
        Path p5 = new Path(TEST_ROOT_DIR + "/" + "testChown/file2");
        Path p6 = new Path(TEST_ROOT_DIR + "/" + "testChown/file3");
        String f7 = TEST_ROOT_DIR + "/" + "testChown/file*";
        TestFsShellReturnCode.writeFile(fileSys, p1);
        Assert.assertTrue((boolean)fileSys.exists(p1));
        this.change(0, "admin", null, f1);
        this.change(1, "admin", null, f2);
        this.change(1, "admin", null, f3);
        TestFsShellReturnCode.writeFile(fileSys, p4);
        Assert.assertTrue((boolean)fileSys.exists(p4));
        TestFsShellReturnCode.writeFile(fileSys, p5);
        Assert.assertTrue((boolean)fileSys.exists(p5));
        TestFsShellReturnCode.writeFile(fileSys, p6);
        Assert.assertTrue((boolean)fileSys.exists(p6));
        this.change(0, "admin", null, f7);
        this.change(0, "admin", "Test", f1);
        this.change(0, "admin", "", f1);
    }

    @Test
    public void testChgrp() throws Exception {
        String f1 = TEST_ROOT_DIR + "/" + "testChgrp/fileExists";
        String f2 = TEST_ROOT_DIR + "/" + "testChgrp/fileDoesNotExist";
        String f3 = TEST_ROOT_DIR + "/" + "testChgrp/nonExistingfiles*";
        Path p1 = new Path(f1);
        Path p4 = new Path(TEST_ROOT_DIR + "/" + "testChgrp/file1");
        Path p5 = new Path(TEST_ROOT_DIR + "/" + "testChgrp/file2");
        Path p6 = new Path(TEST_ROOT_DIR + "/" + "testChgrp/file3");
        String f7 = TEST_ROOT_DIR + "/" + "testChgrp/file*";
        TestFsShellReturnCode.writeFile(fileSys, p1);
        Assert.assertTrue((boolean)fileSys.exists(p1));
        this.change(0, null, "admin", f1);
        this.change(1, null, "admin", f2);
        this.change(1, null, "admin", f2, f1);
        this.change(1, null, "admin", f3);
        this.change(1, null, "admin", f3, f1);
        TestFsShellReturnCode.writeFile(fileSys, p4);
        Assert.assertTrue((boolean)fileSys.exists(p4));
        TestFsShellReturnCode.writeFile(fileSys, p5);
        Assert.assertTrue((boolean)fileSys.exists(p5));
        TestFsShellReturnCode.writeFile(fileSys, p6);
        Assert.assertTrue((boolean)fileSys.exists(p6));
        this.change(0, null, "admin", f7);
        this.change(1, null, "admin", f2, f7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithInvalidSourcePathShouldNotDisplayNullInConsole() throws Exception {
        Configuration conf = new Configuration();
        FsShell shell = new FsShell();
        shell.setConf(conf);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldErr = System.err;
        System.setErr(out);
        try {
            Path tdir = new Path(TEST_ROOT_DIR, "notNullCopy");
            fileSys.delete(tdir, true);
            fileSys.mkdirs(tdir);
            String[] args = new String[]{"-get", tdir + "/invalidSrc", tdir + "/invalidDst"};
            Assert.assertTrue((String)"file exists", (!fileSys.exists(new Path(args[1])) ? 1 : 0) != 0);
            Assert.assertTrue((String)"file exists", (!fileSys.exists(new Path(args[2])) ? 1 : 0) != 0);
            int run = shell.run(args);
            String results = bytes.toString();
            Assert.assertEquals((String)"Return code should be 1", (long)1L, (long)run);
            Assert.assertTrue((String)" Null is coming when source path is invalid. ", (!results.contains("get: null") ? 1 : 0) != 0);
            Assert.assertTrue((String)" Not displaying the intended message ", (boolean)results.contains("get: `" + args[1] + "': No such file or directory"));
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setErr(oldErr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidDefaultFS() throws Exception {
        FsShell shell = new FsShell();
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hhhh://doesnotexist/");
        shell.setConf(conf);
        String[] args = new String[]{"-ls", "file:///"};
        int res = shell.run(args);
        System.out.println("res =" + res);
        shell.setConf(conf);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldErr = System.err;
        System.setErr(out);
        try {
            int run = shell.run(args);
            String results = bytes.toString();
            LOG.info((Object)("result=" + results));
            Assert.assertTrue((String)"Return code should be 0", (run == 0 ? 1 : 0) != 0);
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setErr(oldErr);
        }
    }

    static {
        TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/testCHReturnCode");
    }

    static class RawLocalFileSystemExtn
    extends RawLocalFileSystem {
        protected static HashMap<String, String> owners = new HashMap();
        protected static HashMap<String, String> groups = new HashMap();

        RawLocalFileSystemExtn() {
        }

        public FSDataOutputStream create(Path p) throws IOException {
            return super.create(p);
        }

        public void setOwner(Path p, String username, String groupname) throws IOException {
            String f = this.makeQualified(p).toString();
            if (username != null) {
                owners.put(f, username);
            }
            if (groupname != null) {
                groups.put(f, groupname);
            }
        }

        public FileStatus getFileStatus(Path p) throws IOException {
            String f = this.makeQualified(p).toString();
            FileStatus stat = super.getFileStatus(p);
            stat.getPermission();
            if (owners.containsKey(f)) {
                stat.setOwner("STUB-" + owners.get(f));
            } else {
                stat.setOwner("REAL-" + stat.getOwner());
            }
            if (groups.containsKey(f)) {
                stat.setGroup("STUB-" + groups.get(f));
            } else {
                stat.setGroup("REAL-" + stat.getGroup());
            }
            return stat;
        }
    }

    static class LocalFileSystemExtn
    extends LocalFileSystem {
        public LocalFileSystemExtn() {
            super((FileSystem)new RawLocalFileSystemExtn());
        }
    }
}

