/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalFileSystem {
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/work-dir/localfs");
    private Configuration conf;
    private FileSystem fileSys;

    private void cleanupFile(FileSystem fs, Path name) throws IOException {
        Assert.assertTrue((boolean)fs.exists(name));
        fs.delete(name, true);
        Assert.assertTrue((!fs.exists(name) ? 1 : 0) != 0);
    }

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.fileSys = FileSystem.getLocal((Configuration)this.conf);
        this.fileSys.delete(new Path(TEST_ROOT_DIR), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkingDirectory() throws IOException {
        Path origDir = this.fileSys.getWorkingDirectory();
        Path subdir = new Path(TEST_ROOT_DIR, "new");
        try {
            Assert.assertTrue((!this.fileSys.exists(subdir) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.fileSys.mkdirs(subdir));
            Assert.assertTrue((boolean)this.fileSys.isDirectory(subdir));
            this.fileSys.setWorkingDirectory(subdir);
            Path dir1 = new Path("dir1");
            Assert.assertTrue((boolean)this.fileSys.mkdirs(dir1));
            Assert.assertTrue((boolean)this.fileSys.isDirectory(dir1));
            this.fileSys.delete(dir1, true);
            Assert.assertTrue((!this.fileSys.exists(dir1) ? 1 : 0) != 0);
            Path file1 = new Path("file1");
            Path file2 = new Path("sub/file2");
            String contents = FileSystemTestHelper.writeFile(this.fileSys, file1, 1);
            this.fileSys.copyFromLocalFile(file1, file2);
            Assert.assertTrue((boolean)this.fileSys.exists(file1));
            Assert.assertTrue((boolean)this.fileSys.isFile(file1));
            this.cleanupFile(this.fileSys, file2);
            this.fileSys.copyToLocalFile(file1, file2);
            this.cleanupFile(this.fileSys, file2);
            this.fileSys.rename(file1, file2);
            Assert.assertTrue((!this.fileSys.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.fileSys.exists(file2));
            this.fileSys.rename(file2, file1);
            FSDataInputStream stm = this.fileSys.open(file1);
            byte[] buffer = new byte[3];
            int bytesRead = stm.read(buffer, 0, 3);
            Assert.assertEquals((Object)contents, (Object)new String(buffer, 0, bytesRead));
            stm.close();
        }
        finally {
            this.fileSys.setWorkingDirectory(origDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncable() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRawFileSystem();
        Path file = new Path(TEST_ROOT_DIR, "syncable");
        FSDataOutputStream out = fs.create(file);
        boolean bytesWritten = true;
        byte[] expectedBuf = new byte[]{48, 49, 50, 51};
        try {
            out.write(expectedBuf, 0, 1);
            out.hflush();
            this.verifyFile(fs, file, 1, expectedBuf);
            out.write(expectedBuf, 1, expectedBuf.length - 1);
            out.hsync();
            this.verifyFile(fs, file, expectedBuf.length, expectedBuf);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFile(FileSystem fs, Path file, int bytesToVerify, byte[] expectedBytes) throws IOException {
        FSDataInputStream in = fs.open(file);
        try {
            byte[] readBuf = new byte[bytesToVerify];
            in.readFully(readBuf, 0, bytesToVerify);
            for (int i = 0; i < bytesToVerify; ++i) {
                Assert.assertEquals((long)expectedBytes[i], (long)readBuf[i]);
            }
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testCopy() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path src = new Path(TEST_ROOT_DIR, "dingo");
        Path dst = new Path(TEST_ROOT_DIR, "yak");
        FileSystemTestHelper.writeFile((FileSystem)fs, src, 1);
        Assert.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dst, (boolean)true, (boolean)false, (Configuration)conf));
        Assert.assertTrue((!fs.exists(src) && fs.exists(dst) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)false, (boolean)false, (Configuration)conf));
        Assert.assertTrue((fs.exists(src) && fs.exists(dst) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dst, (boolean)true, (boolean)true, (Configuration)conf));
        Assert.assertTrue((!fs.exists(src) && fs.exists(dst) ? 1 : 0) != 0);
        fs.mkdirs(src);
        Assert.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)false, (boolean)false, (Configuration)conf));
        Path tmp = new Path(src, dst.getName());
        Assert.assertTrue((fs.exists(tmp) && fs.exists(dst) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)false, (boolean)true, (Configuration)conf));
        Assert.assertTrue((boolean)fs.delete(tmp, true));
        fs.mkdirs(tmp);
        try {
            FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)true, (boolean)true, (Configuration)conf);
            Assert.fail((String)"Failed to detect existing dir");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Test
    public void testHomeDirectory() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        Path home = new Path(System.getProperty("user.home")).makeQualified((FileSystem)fileSys);
        Path fsHome = fileSys.getHomeDirectory();
        Assert.assertEquals((Object)home, (Object)fsHome);
    }

    @Test
    public void testPathEscapes() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(TEST_ROOT_DIR, "foo%bar");
        FileSystemTestHelper.writeFile((FileSystem)fs, path, 1);
        FileStatus status = fs.getFileStatus(path);
        Assert.assertEquals((Object)path.makeQualified((FileSystem)fs), (Object)status.getPath());
        this.cleanupFile((FileSystem)fs, path);
    }

    @Test
    public void testMkdirs() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path test_dir = new Path(TEST_ROOT_DIR, "test_dir");
        Path test_file = new Path(TEST_ROOT_DIR, "file1");
        Assert.assertTrue((boolean)fs.mkdirs(test_dir));
        FileSystemTestHelper.writeFile((FileSystem)fs, test_file, 1);
        Path bad_dir = new Path(test_file, "another_dir");
        try {
            fs.mkdirs(bad_dir);
            Assert.fail((String)"Failed to detect existing file in path");
        }
        catch (FileAlreadyExistsException e) {
            // empty catch block
        }
        try {
            fs.mkdirs(null);
            Assert.fail((String)"Failed to detect null in mkdir arg");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testBasicDelete() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path dir1 = new Path(TEST_ROOT_DIR, "dir1");
        Path file1 = new Path(TEST_ROOT_DIR, "file1");
        Path file2 = new Path(TEST_ROOT_DIR + "/dir1", "file2");
        Path file3 = new Path(TEST_ROOT_DIR, "does-not-exist");
        Assert.assertTrue((boolean)fs.mkdirs(dir1));
        FileSystemTestHelper.writeFile((FileSystem)fs, file1, 1);
        FileSystemTestHelper.writeFile((FileSystem)fs, file2, 1);
        Assert.assertFalse((String)"Returned true deleting non-existant path", (boolean)fs.delete(file3));
        Assert.assertTrue((String)"Did not delete file", (boolean)fs.delete(file1));
        Assert.assertTrue((String)"Did not delete non-empty dir", (boolean)fs.delete(dir1));
    }

    @Test
    public void testStatistics() throws Exception {
        FileSystem.getLocal((Configuration)new Configuration());
        int fileSchemeCount = 0;
        for (FileSystem.Statistics stats : FileSystem.getAllStatistics()) {
            if (!stats.getScheme().equals("file")) continue;
            ++fileSchemeCount;
        }
        Assert.assertEquals((long)1L, (long)fileSchemeCount);
    }

    public void testHasFileDescriptor() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(TEST_ROOT_DIR, "test-file");
        FileSystemTestHelper.writeFile((FileSystem)fs, path, 1);
        RawLocalFileSystem rawLocalFileSystem = new RawLocalFileSystem();
        rawLocalFileSystem.getClass();
        BufferedFSInputStream bis = new BufferedFSInputStream((FSInputStream)new RawLocalFileSystem.LocalFSFileInputStream(rawLocalFileSystem, path), 1024);
        Assert.assertNotNull((Object)bis.getFileDescriptor());
    }
}

