/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import org.apache.hadoop.fs.FCStatisticsBaseTest;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class TestLocalFsFCStatistics
extends FCStatisticsBaseTest {
    static final String LOCAL_FS_ROOT_URI = "file:///tmp/test";

    @Before
    public void setUp() throws Exception {
        fc = FileContext.getLocalFSFileContext();
        fc.mkdir(FileContextTestHelper.getTestRootPath(fc, "test"), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        fc.delete(FileContextTestHelper.getTestRootPath(fc, "test"), true);
    }

    @Override
    protected void verifyReadBytes(FileSystem.Statistics stats) {
        Assert.assertEquals((long)blockSize, (long)stats.getBytesRead());
    }

    @Override
    protected void verifyWrittenBytes(FileSystem.Statistics stats) {
        Assert.assertEquals((long)(blockSize + 12), (long)stats.getBytesWritten());
    }

    @Override
    protected URI getFsUri() {
        return URI.create(LOCAL_FS_ROOT_URI);
    }
}

