/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPathData {
    protected static Configuration conf;
    protected static FileSystem fs;
    protected static String dirString;
    protected static Path testDir;
    protected static PathData item;
    protected static String[] d1Paths;
    protected static String[] d2Paths;

    @BeforeClass
    public static void initialize() throws Exception {
        conf = new Configuration();
        fs = FileSystem.getLocal((Configuration)conf);
        testDir = new Path(System.getProperty("test.build.data", "build/test/data") + "/testPD");
        testDir = new Path(fs.makeQualified(testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)conf, (URI)fs.getUri());
        fs.setWorkingDirectory(testDir);
        fs.mkdirs(new Path("d1"));
        fs.createNewFile(new Path("d1", "f1"));
        fs.createNewFile(new Path("d1", "f1.1"));
        fs.createNewFile(new Path("d1", "f2"));
        fs.mkdirs(new Path("d2"));
        fs.create(new Path("d2", "f3"));
    }

    @Test
    public void testWithDirStringAndConf() throws Exception {
        dirString = "d1";
        item = new PathData(dirString, conf);
        this.checkPathData();
        dirString = "d1/";
        item = new PathData(dirString, conf);
        this.checkPathData();
    }

    @Test
    public void testUnqualifiedUriContents() throws Exception {
        dirString = "d1";
        item = new PathData(dirString, conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString("d1/f1", "d1/f1.1", "d1/f2"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testQualifiedUriContents() throws Exception {
        dirString = fs.makeQualified(new Path("d1")).toString();
        item = new PathData(dirString, conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString(dirString + "/f1", dirString + "/f1.1", dirString + "/f2"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testCwdContents() throws Exception {
        dirString = ".";
        item = new PathData(dirString, conf);
        PathData[] items = item.getDirectoryContents();
        Assert.assertEquals((Object)TestPathData.sortedString("d1", "d2"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testToFile() throws Exception {
        item = new PathData(".", conf);
        Assert.assertEquals((Object)new File(testDir.toString()), (Object)item.toFile());
        item = new PathData("d1/f1", conf);
        Assert.assertEquals((Object)new File(testDir + "/d1/f1"), (Object)item.toFile());
        item = new PathData(testDir + "/d1/f1", conf);
        Assert.assertEquals((Object)new File(testDir + "/d1/f1"), (Object)item.toFile());
    }

    @Test
    public void testAbsoluteGlob() throws Exception {
        PathData[] items = PathData.expandAsGlob((String)(testDir + "/d1/f1*"), (Configuration)conf);
        Assert.assertEquals((Object)TestPathData.sortedString(testDir + "/d1/f1", testDir + "/d1/f1.1"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testRelativeGlob() throws Exception {
        PathData[] items = PathData.expandAsGlob((String)"d1/f1*", (Configuration)conf);
        Assert.assertEquals((Object)TestPathData.sortedString("d1/f1", "d1/f1.1"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testRelativeGlobBack() throws Exception {
        fs.setWorkingDirectory(new Path("d1"));
        PathData[] items = PathData.expandAsGlob((String)"../d2/*", (Configuration)conf);
        Assert.assertEquals((Object)TestPathData.sortedString("../d2/f3"), (Object)TestPathData.sortedString(items));
    }

    @Test
    public void testWithStringAndConfForBuggyPath() throws Exception {
        dirString = "file:///tmp";
        testDir = new Path(dirString);
        item = new PathData(dirString, conf);
        Assert.assertEquals((Object)"file:/tmp", (Object)testDir.toString());
        this.checkPathData();
    }

    public void checkPathData() throws Exception {
        Assert.assertEquals((String)"checking fs", (Object)fs, (Object)TestPathData.item.fs);
        Assert.assertEquals((String)"checking string", (Object)dirString, (Object)item.toString());
        Assert.assertEquals((String)"checking path", (Object)fs.makeQualified(new Path(item.toString())), (Object)TestPathData.item.path);
        Assert.assertTrue((String)"checking exist", (TestPathData.item.stat != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"checking isDir", (boolean)TestPathData.item.stat.isDirectory());
    }

    private static String sortedString(Object ... list) {
        Object[] strings = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            strings[i] = String.valueOf(list[i]);
        }
        Arrays.sort(strings);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(i + ":<" + (String)strings[i] + ">");
        }
        return result.toString();
    }

    private static String sortedString(PathData ... items) {
        return TestPathData.sortedString((Object[])items);
    }

    static {
        d1Paths = new String[]{"d1/f1", "d1/f1.1", "d1/f2"};
        d2Paths = new String[]{"d2/f3"};
    }
}

