/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextMainOperationsBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.junit.After;
import org.junit.Before;

public class TestFcMainOperationsLocalFs
extends FileContextMainOperationsBaseTest {
    FileContext fclocal;
    Path targetOfTests;

    @Override
    @Before
    public void setUp() throws Exception {
        this.fclocal = FileContext.getLocalFSFileContext();
        this.targetOfTests = FileContextTestHelper.getTestRootPath(this.fclocal);
        this.fclocal.delete(this.targetOfTests, true);
        this.fclocal.mkdir(this.targetOfTests, FileContext.DEFAULT_PERM, true);
        String srcTestRoot = FileContextTestHelper.TEST_ROOT_DIR.startsWith("/") ? FileContextTestHelper.TEST_ROOT_DIR : "/user/" + System.getProperty("user.name") + "/" + FileContextTestHelper.TEST_ROOT_DIR;
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)srcTestRoot, (URI)this.targetOfTests.toUri());
        fc = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.fclocal.delete(this.targetOfTests, true);
    }
}

