/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestViewFileSystemDelegationTokenSupport {
    private static final String MOUNT_TABLE_NAME = "vfs-cluster";

    @Test
    public void testGetCanonicalServiceNameWithNonDefaultMountTable() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)MOUNT_TABLE_NAME, (String)"/user", (URI)new URI("file:///"));
        FileSystem viewFs = FileSystem.get((URI)new URI("viewfs://vfs-cluster"), (Configuration)conf);
        String serviceName = viewFs.getCanonicalServiceName();
        Assert.assertNull((Object)serviceName);
    }

    @Test
    public void testGetCanonicalServiceNameWithDefaultMountTable() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user", (URI)new URI("file:///"));
        FileSystem viewFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        String serviceName = viewFs.getCanonicalServiceName();
        Assert.assertNull((Object)serviceName);
    }
}

