/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.mortbay.log.Log;

public class ViewFileSystemTestSetup {
    public static FileSystem setupForViewFileSystem(Configuration conf, FileSystem fsTarget) throws Exception {
        fsTarget.mkdirs(FileSystemTestHelper.getTestRootPath(fsTarget));
        String homeDirRoot = fsTarget.getHomeDirectory().getParent().toUri().getPath();
        ConfigUtil.addLink((Configuration)conf, (String)homeDirRoot, (URI)fsTarget.makeQualified(new Path(homeDirRoot)).toUri());
        ConfigUtil.setHomeDirConf((Configuration)conf, (String)homeDirRoot);
        Log.info((String)("Home dir base " + homeDirRoot));
        FileSystem fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        return fsView;
    }

    public static void tearDown(FileSystem fsTarget) throws Exception {
        Path targetOfTests = FileSystemTestHelper.getTestRootPath(fsTarget);
        fsTarget.delete(targetOfTests, true);
    }

    public static Configuration createConfig() {
        Configuration conf = new Configuration();
        conf.set("fs.viewfs.impl", ViewFileSystem.class.getName());
        return conf;
    }
}

