/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestActiveStandbyElector {
    private ZooKeeper mockZK;
    private int count;
    private ActiveStandbyElector.ActiveStandbyElectorCallback mockApp;
    private final byte[] data = new byte[8];
    private ActiveStandbyElectorTester elector;
    private static final String ZK_PARENT_NAME = "/parent/node";
    private static final String ZK_LOCK_NAME = "/parent/node/ActiveStandbyElectorLock";
    private static final String ZK_BREADCRUMB_NAME = "/parent/node/ActiveBreadCrumb";

    @Before
    public void init() throws IOException {
        this.count = 0;
        this.mockZK = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        this.mockApp = (ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.mock(ActiveStandbyElector.ActiveStandbyElectorCallback.class);
        this.elector = new ActiveStandbyElectorTester("hostPort", 1000, ZK_PARENT_NAME, ZooDefs.Ids.OPEN_ACL_UNSAFE, this.mockApp);
    }

    private void mockNoPriorActive() throws Exception {
        ((ZooKeeper)Mockito.doThrow((Throwable)new KeeperException.NoNodeException()).when((Object)this.mockZK)).getData((String)Mockito.eq((Object)ZK_BREADCRUMB_NAME), Mockito.anyBoolean(), (Stat)Mockito.any());
    }

    private void mockPriorActive(byte[] data) throws Exception {
        ((ZooKeeper)Mockito.doReturn((Object)data).when((Object)this.mockZK)).getData((String)Mockito.eq((Object)ZK_BREADCRUMB_NAME), Mockito.anyBoolean(), (Stat)Mockito.any());
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testJoinElectionException() {
        this.elector.joinElection(null);
    }

    @Test
    public void testJoinElection() {
        this.elector.joinElection(this.data);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
    }

    @Test
    public void testCreateNodeResultBecomeActive() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
        this.verifyExistCall(1);
        Stat stat = new Stat();
        stat.setEphemeralOwner(1L);
        Mockito.when((Object)this.mockZK.getSessionId()).thenReturn((Object)1L);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, stat);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)0))).enterNeutralMode();
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)0))).becomeStandby();
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        this.verifyExistCall(1);
    }

    @Test
    public void testFailToBecomeActive() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        Assert.assertEquals((long)0L, (long)this.elector.sleptFor);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.doThrow((Throwable)new ServiceFailedException("failed to become active")).when((Object)this.mockApp)).becomeActive();
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp)).becomeActive();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)2))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        Assert.assertEquals((long)2L, (long)this.count);
        Assert.assertTrue((this.elector.sleptFor > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFailToBecomeActiveAfterZKDisconnect() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        Assert.assertEquals((long)0L, (long)this.elector.sleptFor);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)2))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.verifyExistCall(1);
        Stat stat = new Stat();
        stat.setEphemeralOwner(1L);
        Mockito.when((Object)this.mockZK.getSessionId()).thenReturn((Object)1L);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.doThrow((Throwable)new ServiceFailedException("fail to become active")).when((Object)this.mockApp)).becomeActive();
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, stat);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)3))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        Assert.assertEquals((long)2L, (long)this.count);
        Assert.assertTrue((this.elector.sleptFor > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFencesOldActive() throws Exception {
        byte[] fakeOldActiveData = new byte[]{};
        this.mockPriorActive(fakeOldActiveData);
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).fenceOldActive(fakeOldActiveData);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).setData((String)Mockito.eq((Object)ZK_BREADCRUMB_NAME), (byte[])Mockito.eq((Object)this.data), Mockito.eq((int)0));
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
    }

    @Test
    public void testQuitElectionRemovesBreadcrumbNode() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).create((String)Mockito.eq((Object)ZK_BREADCRUMB_NAME), (byte[])Mockito.eq((Object)this.data), (List)Mockito.eq((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE), (CreateMode)Mockito.eq((Object)CreateMode.PERSISTENT));
        this.mockPriorActive(this.data);
        this.elector.quitElection(false);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).delete((String)Mockito.eq((Object)ZK_BREADCRUMB_NAME), Mockito.eq((int)0));
    }

    @Test
    public void testCreateNodeResultBecomeStandby() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeStandby();
        this.verifyExistCall(1);
    }

    @Test
    public void testCreateNodeResultError() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.APIERROR.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).notifyFatalError("Received create error from Zookeeper. code:APIERROR for path /parent/node/ActiveStandbyElectorLock");
    }

    @Test
    public void testCreateNodeResultRetryBecomeActive() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).notifyFatalError("Received create error from Zookeeper. code:CONNECTIONLOSS for path /parent/node/ActiveStandbyElectorLock. Not retrying further znode create connection errors.");
        this.elector.joinElection(this.data);
        Assert.assertEquals((long)2L, (long)this.count);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.verifyExistCall(1);
        Stat stat = new Stat();
        stat.setEphemeralOwner(1L);
        Mockito.when((Object)this.mockZK.getSessionId()).thenReturn((Object)1L);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, stat);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
        this.verifyExistCall(1);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)6))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
    }

    @Test
    public void testCreateNodeResultRetryBecomeStandby() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.verifyExistCall(1);
        Stat stat = new Stat();
        stat.setEphemeralOwner(0L);
        Mockito.when((Object)this.mockZK.getSessionId()).thenReturn((Object)1L);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, stat);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeStandby();
        this.verifyExistCall(1);
    }

    @Test
    public void testCreateNodeResultRetryNoNode() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        this.verifyExistCall(1);
        this.elector.processResult(KeeperException.Code.NONODE.intValue(), ZK_LOCK_NAME, this.mockZK, null);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).enterNeutralMode();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)4))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
    }

    @Test
    public void testStatNodeRetry() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, null);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, null);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, null);
        this.elector.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), ZK_LOCK_NAME, this.mockZK, null);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).notifyFatalError("Received stat error from Zookeeper. code:CONNECTIONLOSS. Not retrying further znode monitoring connection errors.");
    }

    @Test
    public void testStatNodeError() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue(), ZK_LOCK_NAME, this.mockZK, null);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)0))).enterNeutralMode();
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).notifyFatalError("Received stat error from Zookeeper. code:RUNTIMEINCONSISTENCY");
    }

    @Test
    public void testProcessCallbackEventNone() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        WatchedEvent mockEvent = (WatchedEvent)Mockito.mock(WatchedEvent.class);
        Mockito.when((Object)mockEvent.getType()).thenReturn((Object)Watcher.Event.EventType.None);
        Mockito.when((Object)mockEvent.getState()).thenReturn((Object)Watcher.Event.KeeperState.SyncConnected);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)0))).exists(Mockito.anyString(), Mockito.anyBoolean(), (AsyncCallback.StatCallback)Mockito.anyObject(), Mockito.anyObject());
        Mockito.when((Object)mockEvent.getState()).thenReturn((Object)Watcher.Event.KeeperState.Disconnected);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).enterNeutralMode();
        Mockito.when((Object)mockEvent.getState()).thenReturn((Object)Watcher.Event.KeeperState.SyncConnected);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        this.verifyExistCall(1);
        Mockito.when((Object)mockEvent.getState()).thenReturn((Object)Watcher.Event.KeeperState.Expired);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).enterNeutralMode();
        Assert.assertEquals((long)2L, (long)this.count);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)2))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
        this.verifyExistCall(2);
        Mockito.when((Object)mockEvent.getState()).thenReturn((Object)Watcher.Event.KeeperState.AuthFailed);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).notifyFatalError("Unexpected Zookeeper watch event state: AuthFailed");
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).enterNeutralMode();
    }

    @Test
    public void testProcessCallbackEventNode() throws Exception {
        this.mockNoPriorActive();
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeStandby();
        this.verifyExistCall(1);
        WatchedEvent mockEvent = (WatchedEvent)Mockito.mock(WatchedEvent.class);
        Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)ZK_LOCK_NAME);
        Mockito.when((Object)mockEvent.getType()).thenReturn((Object)Watcher.Event.EventType.NodeDataChanged);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        this.verifyExistCall(2);
        Mockito.when((Object)mockEvent.getType()).thenReturn((Object)Watcher.Event.EventType.NodeChildrenChanged);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        this.verifyExistCall(3);
        Mockito.when((Object)mockEvent.getType()).thenReturn((Object)Watcher.Event.EventType.NodeDeleted);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)0))).enterNeutralMode();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)2))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeActive();
        this.verifyExistCall(4);
        Mockito.when((Object)mockEvent.getType()).thenReturn((Object)Watcher.Event.EventType.NodeDeleted);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).enterNeutralMode();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)3))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        this.elector.processResult(KeeperException.Code.OK.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)2))).becomeActive();
        this.verifyExistCall(5);
        Mockito.when((Object)mockEvent.getPath()).thenReturn(null);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).notifyFatalError("Unexpected watch error from Zookeeper");
        Assert.assertEquals((long)1L, (long)this.count);
        this.verifyExistCall(5);
    }

    private void verifyExistCall(int times) {
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)times))).exists((String)Mockito.eq((Object)ZK_LOCK_NAME), (Watcher)Mockito.any(), (AsyncCallback.StatCallback)Mockito.same((Object)((Object)this.elector)), Mockito.same((Object)this.mockZK));
    }

    @Test
    public void testSuccessiveStandbyCalls() {
        this.elector.joinElection(this.data);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeStandby();
        this.verifyExistCall(1);
        WatchedEvent mockEvent = (WatchedEvent)Mockito.mock(WatchedEvent.class);
        Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)ZK_LOCK_NAME);
        Mockito.when((Object)mockEvent.getType()).thenReturn((Object)Watcher.Event.EventType.NodeDeleted);
        this.elector.processWatchEvent(this.mockZK, mockEvent);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)0))).enterNeutralMode();
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)2))).create(ZK_LOCK_NAME, this.data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)this.elector, (Object)this.mockZK);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeStandby();
        this.verifyExistCall(2);
    }

    @Test
    public void testQuitElection() throws Exception {
        this.elector.joinElection(this.data);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)0))).close();
        this.elector.quitElection(true);
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).close();
        this.verifyExistCall(0);
        byte[] data = new byte[8];
        this.elector.joinElection(data);
        Assert.assertEquals((long)2L, (long)this.count);
        this.elector.processResult(KeeperException.Code.NODEEXISTS.intValue(), ZK_LOCK_NAME, this.mockZK, ZK_LOCK_NAME);
        ((ActiveStandbyElector.ActiveStandbyElectorCallback)Mockito.verify((Object)this.mockApp, (VerificationMode)Mockito.times((int)1))).becomeStandby();
        this.verifyExistCall(1);
    }

    @Test
    public void testGetActiveData() throws ActiveStandbyElector.ActiveNotFoundException, KeeperException, InterruptedException, IOException {
        byte[] data = new byte[8];
        Mockito.when((Object)this.mockZK.getData((String)Mockito.eq((Object)ZK_LOCK_NAME), Mockito.eq((boolean)false), (Stat)Mockito.anyObject())).thenReturn((Object)data);
        Assert.assertEquals((Object)data, (Object)this.elector.getActiveData());
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)1))).getData((String)Mockito.eq((Object)ZK_LOCK_NAME), Mockito.eq((boolean)false), (Stat)Mockito.anyObject());
        Mockito.when((Object)this.mockZK.getData((String)Mockito.eq((Object)ZK_LOCK_NAME), Mockito.eq((boolean)false), (Stat)Mockito.anyObject())).thenThrow(new Throwable[]{new KeeperException.NoNodeException()});
        try {
            this.elector.getActiveData();
            Assert.fail((String)"ActiveNotFoundException expected");
        }
        catch (ActiveStandbyElector.ActiveNotFoundException e) {
            ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)2))).getData((String)Mockito.eq((Object)ZK_LOCK_NAME), Mockito.eq((boolean)false), (Stat)Mockito.anyObject());
        }
        try {
            Mockito.when((Object)this.mockZK.getData((String)Mockito.eq((Object)ZK_LOCK_NAME), Mockito.eq((boolean)false), (Stat)Mockito.anyObject())).thenThrow(new Throwable[]{new KeeperException.AuthFailedException()});
            this.elector.getActiveData();
            Assert.fail((String)"KeeperException.AuthFailedException expected");
        }
        catch (KeeperException.AuthFailedException ke) {
            ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)3))).getData((String)Mockito.eq((Object)ZK_LOCK_NAME), Mockito.eq((boolean)false), (Stat)Mockito.anyObject());
        }
    }

    @Test
    public void testEnsureBaseNode() throws Exception {
        this.elector.ensureParentZNode();
        StringBuilder prefix = new StringBuilder();
        for (String part : ZK_PARENT_NAME.split("/")) {
            if (part.isEmpty()) continue;
            prefix.append("/").append(part);
            if ("/".equals(prefix.toString())) continue;
            ((ZooKeeper)Mockito.verify((Object)this.mockZK)).create((String)Mockito.eq((Object)prefix.toString()), (byte[])Mockito.any(), (List)Mockito.eq((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE), (CreateMode)Mockito.eq((Object)CreateMode.PERSISTENT));
        }
    }

    @Test
    public void testEnsureBaseNodeFails() throws Exception {
        block2: {
            ((ZooKeeper)Mockito.doThrow((Throwable)new KeeperException.ConnectionLossException()).when((Object)this.mockZK)).create((String)Mockito.eq((Object)ZK_PARENT_NAME), (byte[])Mockito.any(), (List)Mockito.eq((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE), (CreateMode)Mockito.eq((Object)CreateMode.PERSISTENT));
            try {
                this.elector.ensureParentZNode();
                Assert.fail((String)"Did not throw!");
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof KeeperException.ConnectionLossException) break block2;
                throw ioe;
            }
        }
        ((ZooKeeper)Mockito.verify((Object)this.mockZK, (VerificationMode)Mockito.times((int)3))).create((String)Mockito.eq((Object)ZK_PARENT_NAME), (byte[])Mockito.any(), (List)Mockito.eq((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE), (CreateMode)Mockito.eq((Object)CreateMode.PERSISTENT));
    }

    class ActiveStandbyElectorTester
    extends ActiveStandbyElector {
        private int sleptFor;

        ActiveStandbyElectorTester(String hostPort, int timeout, String parent, List<ACL> acl, ActiveStandbyElector.ActiveStandbyElectorCallback app) throws IOException {
            super(hostPort, timeout, parent, acl, Collections.emptyList(), app);
            this.sleptFor = 0;
        }

        public ZooKeeper getNewZooKeeper() {
            ++TestActiveStandbyElector.this.count;
            return TestActiveStandbyElector.this.mockZK;
        }

        protected void sleepFor(int ms) {
            LOG.info((Object)("Would have slept for " + ms + "ms"));
            this.sleptFor += ms;
        }
    }
}

