/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.hadoop.ha.HAZKUtil;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import org.junit.Test;

public class TestHAZKUtil {
    private static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "/tmp") + "/TestHAZKUtil";
    private static final File TEST_FILE = new File(TEST_ROOT_DIR, "test-file");
    private static final String BOGUS_FILE = "/xxxx-this-does-not-exist";

    @Test
    public void testEmptyACL() {
        List result = HAZKUtil.parseACLs((String)"");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNullACL() {
        List result = HAZKUtil.parseACLs(null);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testInvalidACLs() {
        TestHAZKUtil.badAcl("a:b", "ACL 'a:b' not of expected form scheme:id:perm");
        TestHAZKUtil.badAcl("a", "ACL 'a' not of expected form scheme:id:perm");
        TestHAZKUtil.badAcl("password:foo:rx", "Invalid permission 'x' in permission string 'rx'");
    }

    private static void badAcl(String acls, String expectedErr) {
        try {
            HAZKUtil.parseACLs((String)acls);
            Assert.fail((String)("Should have failed to parse '" + acls + "'"));
        }
        catch (HAZKUtil.BadAclFormatException e) {
            Assert.assertEquals((Object)expectedErr, (Object)e.getMessage());
        }
    }

    @Test
    public void testGoodACLs() {
        List result = HAZKUtil.parseACLs((String)"sasl:hdfs/host1@MY.DOMAIN:cdrwa, sasl:hdfs/host2@MY.DOMAIN:ca");
        ACL acl0 = (ACL)result.get(0);
        Assert.assertEquals((long)31L, (long)acl0.getPerms());
        Assert.assertEquals((Object)"sasl", (Object)acl0.getId().getScheme());
        Assert.assertEquals((Object)"hdfs/host1@MY.DOMAIN", (Object)acl0.getId().getId());
        ACL acl1 = (ACL)result.get(1);
        Assert.assertEquals((long)20L, (long)acl1.getPerms());
        Assert.assertEquals((Object)"sasl", (Object)acl1.getId().getScheme());
        Assert.assertEquals((Object)"hdfs/host2@MY.DOMAIN", (Object)acl1.getId().getId());
    }

    @Test
    public void testEmptyAuth() {
        List result = HAZKUtil.parseAuth((String)"");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNullAuth() {
        List result = HAZKUtil.parseAuth(null);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGoodAuths() {
        List result = HAZKUtil.parseAuth((String)"scheme:data,\n   scheme2:user:pass");
        Assert.assertEquals((long)2L, (long)result.size());
        HAZKUtil.ZKAuthInfo auth0 = (HAZKUtil.ZKAuthInfo)result.get(0);
        Assert.assertEquals((Object)"scheme", (Object)auth0.getScheme());
        Assert.assertEquals((Object)"data", (Object)new String(auth0.getAuth()));
        HAZKUtil.ZKAuthInfo auth1 = (HAZKUtil.ZKAuthInfo)result.get(1);
        Assert.assertEquals((Object)"scheme2", (Object)auth1.getScheme());
        Assert.assertEquals((Object)"user:pass", (Object)new String(auth1.getAuth()));
    }

    @Test
    public void testConfIndirection() throws IOException {
        Assert.assertNull((Object)HAZKUtil.resolveConfIndirection(null));
        Assert.assertEquals((Object)"x", (Object)HAZKUtil.resolveConfIndirection((String)"x"));
        TEST_FILE.getParentFile().mkdirs();
        Files.write((CharSequence)"hello world", (File)TEST_FILE, (Charset)Charsets.UTF_8);
        Assert.assertEquals((Object)"hello world", (Object)HAZKUtil.resolveConfIndirection((String)("@" + TEST_FILE.getAbsolutePath())));
        try {
            HAZKUtil.resolveConfIndirection((String)"@/xxxx-this-does-not-exist");
            Assert.fail((String)"Did not throw for non-existent file reference");
        }
        catch (FileNotFoundException fnfe) {
            Assert.assertTrue((boolean)fnfe.getMessage().startsWith(BOGUS_FILE));
        }
    }
}

