/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.ShellCommandFencer;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestShellCommandFencer {
    private ShellCommandFencer fencer = TestShellCommandFencer.createFencer();
    private static final HAServiceTarget TEST_TARGET = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, new InetSocketAddress("host", 1234));

    @BeforeClass
    public static void setupLogSpy() {
        ShellCommandFencer.LOG = (Log)Mockito.spy((Object)ShellCommandFencer.LOG);
    }

    @Before
    public void resetLogSpy() {
        Mockito.reset((Object[])new Log[]{ShellCommandFencer.LOG});
    }

    private static ShellCommandFencer createFencer() {
        Configuration conf = new Configuration();
        conf.set("in.fencing.tests", "yessir");
        ShellCommandFencer fencer = new ShellCommandFencer();
        fencer.setConf(conf);
        return fencer;
    }

    @Test
    public void testBasicSuccessFailure() {
        Assert.assertTrue((boolean)this.fencer.tryFence(TEST_TARGET, "echo"));
        Assert.assertFalse((boolean)this.fencer.tryFence(TEST_TARGET, "exit 1"));
        Assert.assertFalse((boolean)this.fencer.tryFence(TEST_TARGET, "xxxxxxxxxxxx"));
    }

    @Test
    public void testCheckNoArgs() {
        try {
            Configuration conf = new Configuration();
            new NodeFencer(conf, "shell");
            Assert.fail((String)"Didn't throw when passing no args to shell");
        }
        catch (BadFencingConfigurationException confe) {
            Assert.assertTrue((String)("Unexpected exception:" + StringUtils.stringifyException((Throwable)confe)), (boolean)confe.getMessage().contains("No argument passed"));
        }
    }

    @Test
    public void testCheckParensNoArgs() {
        try {
            Configuration conf = new Configuration();
            new NodeFencer(conf, "shell()");
            Assert.fail((String)"Didn't throw when passing no args to shell");
        }
        catch (BadFencingConfigurationException confe) {
            Assert.assertTrue((String)("Unexpected exception:" + StringUtils.stringifyException((Throwable)confe)), (boolean)confe.getMessage().contains("Unable to parse line: 'shell()'"));
        }
    }

    @Test
    public void testStdoutLogging() {
        Assert.assertTrue((boolean)this.fencer.tryFence(TEST_TARGET, "echo hello"));
        ((Log)Mockito.verify((Object)ShellCommandFencer.LOG)).info((Object)Mockito.endsWith((String)"echo hello: hello"));
    }

    @Test
    public void testStderrLogging() {
        Assert.assertTrue((boolean)this.fencer.tryFence(TEST_TARGET, "echo hello >&2"));
        ((Log)Mockito.verify((Object)ShellCommandFencer.LOG)).warn((Object)Mockito.endsWith((String)"echo hello >&2: hello"));
    }

    @Test
    public void testConfAsEnvironment() {
        this.fencer.tryFence(TEST_TARGET, "echo $in_fencing_tests");
        ((Log)Mockito.verify((Object)ShellCommandFencer.LOG)).info((Object)Mockito.endsWith((String)"echo $in...ing_tests: yessir"));
    }

    @Test
    public void testTargetAsEnvironment() {
        this.fencer.tryFence(TEST_TARGET, "echo $target_host $target_port $target_address");
        ((Log)Mockito.verify((Object)ShellCommandFencer.LOG)).info((Object)Mockito.endsWith((String)"echo $ta...t_address: host 1234 host:1234"));
    }

    @Test(timeout=10000L)
    public void testSubprocessInputIsClosed() {
        Assert.assertFalse((boolean)this.fencer.tryFence(TEST_TARGET, "read"));
    }

    @Test
    public void testCommandAbbreviation() {
        Assert.assertEquals((Object)"a...f", (Object)ShellCommandFencer.abbreviate((String)"abcdef", (int)5));
        Assert.assertEquals((Object)"abcdef", (Object)ShellCommandFencer.abbreviate((String)"abcdef", (int)6));
        Assert.assertEquals((Object)"abcdef", (Object)ShellCommandFencer.abbreviate((String)"abcdef", (int)7));
        Assert.assertEquals((Object)"a...g", (Object)ShellCommandFencer.abbreviate((String)"abcdefg", (int)5));
        Assert.assertEquals((Object)"a...h", (Object)ShellCommandFencer.abbreviate((String)"abcdefgh", (int)5));
        Assert.assertEquals((Object)"a...gh", (Object)ShellCommandFencer.abbreviate((String)"abcdefgh", (int)6));
        Assert.assertEquals((Object)"ab...gh", (Object)ShellCommandFencer.abbreviate((String)"abcdefgh", (int)7));
    }
}

