/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.resource.JerseyResource;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.util.ajax.JSON;

public class TestHttpServer
extends HttpServerFunctionalTest {
    static final Log LOG = LogFactory.getLog(TestHttpServer.class);
    private static HttpServer server;
    private static URL baseUrl;
    private static final int MAX_THREADS = 10;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.http.max.threads", 10);
        server = TestHttpServer.createTestServer(conf);
        server.addServlet("echo", "/echo", EchoServlet.class);
        server.addServlet("echomap", "/echomap", EchoMapServlet.class);
        server.addServlet("htmlcontent", "/htmlcontent", HtmlContentServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestHttpServer.getServerURL(server);
        LOG.info((Object)("HTTP server started: " + baseUrl));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    @Test
    public void testMaxThreads() throws Exception {
        int clientThreads = 100;
        ExecutorService executor = Executors.newFixedThreadPool(clientThreads);
        final CountDownLatch ready = new CountDownLatch(clientThreads);
        final CountDownLatch start = new CountDownLatch(1);
        for (int i = 0; i < clientThreads; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ready.countDown();
                    try {
                        start.await();
                        Assert.assertEquals((Object)"a:b\nc:d\n", (Object)HttpServerFunctionalTest.readOutput(new URL(baseUrl, "/echo?a=b&c=d")));
                        int serverThreads = server.webServer.getThreadPool().getThreads();
                        Assert.assertTrue((String)("More threads are started than expected, Server Threads count: " + serverThreads), (serverThreads <= 10 ? 1 : 0) != 0);
                        System.out.println("Number of threads = " + serverThreads + " which is less or equal than the max = " + 10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        ready.await();
        start.countDown();
    }

    @Test
    public void testEcho() throws Exception {
        TestHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echo?a=b&c=d")));
        TestHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    @Test
    public void testEchoMap() throws Exception {
        TestHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echomap?a=b&c=d")));
        TestHttpServer.assertEquals((Object)"a:b,&gt;\nc&lt;:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echomap?a=b&c<=d&a=>")));
    }

    @Test
    public void testContentTypes() throws Exception {
        URL cssUrl = new URL(baseUrl, "/static/test.css");
        HttpURLConnection conn = (HttpURLConnection)cssUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/css", (Object)conn.getContentType());
        URL servletUrl = new URL(baseUrl, "/echo?a=b");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/plain; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/echo?a=b.css");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/plain; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/htmlcontent");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/html; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/testjsp.jsp");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/html; charset=utf-8", (Object)conn.getContentType());
    }

    static int getHttpStatusCode(String urlstring, String userName) throws IOException {
        URL url = new URL(urlstring + "?user.name=" + userName);
        System.out.println("Accessing " + url + " as user " + userName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        return connection.getResponseCode();
    }

    @Test
    public void testDisabledAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        HttpServer myServer = new HttpServer("test", "0.0.0.0", 0, true, conf);
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        int port = myServer.getPort();
        String serverURL = "http://localhost:" + port + "/";
        for (String servlet : new String[]{"conf", "logs", "stacks", "logLevel", "metrics"}) {
            for (String user : new String[]{"userA", "userB"}) {
                TestHttpServer.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
        }
        myServer.stop();
    }

    @Test
    public void testAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", true);
        conf.setBoolean("hadoop.security.instrumentation.requires.admin", true);
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        MyGroupsProvider.mapping.put("userC", Arrays.asList("groupC"));
        MyGroupsProvider.mapping.put("userD", Arrays.asList("groupD"));
        MyGroupsProvider.mapping.put("userE", Arrays.asList("groupE"));
        HttpServer myServer = new HttpServer("test", "0.0.0.0", 0, true, conf, new AccessControlList("userA,userB groupC,groupD"));
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        int port = myServer.getPort();
        String serverURL = "http://localhost:" + port + "/";
        for (String servlet : new String[]{"conf", "logs", "stacks", "logLevel", "metrics"}) {
            for (String user : new String[]{"userA", "userB", "userC", "userD"}) {
                TestHttpServer.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
            TestHttpServer.assertEquals((long)401L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, "userE"));
        }
        myServer.stop();
    }

    @Test
    public void testRequestQuoterWithNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)request)).getParameterValues("dummy");
        HttpServer.QuotingInputFilter.RequestQuoter requestQuoter = new HttpServer.QuotingInputFilter.RequestQuoter(request);
        String[] parameterValues = requestQuoter.getParameterValues("dummy");
        junit.framework.Assert.assertEquals((String)"It should return null when there are no values for the parameter", null, (Object)parameterValues);
    }

    @Test
    public void testRequestQuoterWithNotNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Object[] values = new String[]{"abc", "def"};
        ((HttpServletRequest)Mockito.doReturn((Object)values).when((Object)request)).getParameterValues("dummy");
        HttpServer.QuotingInputFilter.RequestQuoter requestQuoter = new HttpServer.QuotingInputFilter.RequestQuoter(request);
        Object[] parameterValues = requestQuoter.getParameterValues("dummy");
        junit.framework.Assert.assertTrue((String)"It should return Parameter Values", (boolean)Arrays.equals(values, parameterValues));
    }

    private static Map<String, Object> parse(String jsonString) {
        return (Map)JSON.parse((String)jsonString);
    }

    @Test
    public void testJersey() throws Exception {
        LOG.info((Object)"BEGIN testJersey()");
        String js = TestHttpServer.readOutput(new URL(baseUrl, "/jersey/foo?op=bar"));
        Map<String, Object> m = TestHttpServer.parse(js);
        LOG.info((Object)("m=" + m));
        TestHttpServer.assertEquals((Object)"foo", (Object)m.get("path"));
        TestHttpServer.assertEquals((Object)"bar", (Object)m.get("op"));
        LOG.info((Object)"END testJersey()");
    }

    @Test
    public void testHasAdministratorAccess() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", false);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("hadoop.conf")).thenReturn((Object)conf);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn(null);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        junit.framework.Assert.assertTrue((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        conf.setBoolean("hadoop.security.authorization", true);
        junit.framework.Assert.assertFalse((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"foo");
        junit.framework.Assert.assertTrue((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        AccessControlList acls = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        junit.framework.Assert.assertFalse((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        junit.framework.Assert.assertTrue((boolean)HttpServer.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
    }

    @Test
    public void testRequiresAuthorizationAccess() throws Exception {
        Configuration conf = new Configuration();
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("hadoop.conf")).thenReturn((Object)conf);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        junit.framework.Assert.assertTrue((boolean)HttpServer.isInstrumentationAccessAllowed((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        conf.setBoolean("hadoop.security.instrumentation.requires.admin", true);
        conf.setBoolean("hadoop.security.authorization", true);
        AccessControlList acls = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        junit.framework.Assert.assertFalse((boolean)HttpServer.isInstrumentationAccessAllowed((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindAddress() throws Exception {
        this.checkBindAddress("0.0.0.0", 0, false).stop();
        HttpServer myServer = this.checkBindAddress("localhost", 0, false);
        HttpServer myServer2 = null;
        try {
            int port = myServer.getListenerAddress().getPort();
            myServer2 = this.checkBindAddress("localhost", port, true);
            port = myServer2.getListenerAddress().getPort();
            myServer2.stop();
            TestHttpServer.assertEquals((long)-1L, (long)myServer2.getPort());
            myServer2.openListener();
            TestHttpServer.assertEquals((long)port, (long)myServer2.getPort());
        }
        finally {
            myServer.stop();
            if (myServer2 != null) {
                myServer2.stop();
            }
        }
    }

    private HttpServer checkBindAddress(String host, int port, boolean findPort) throws Exception {
        HttpServer server = TestHttpServer.createServer(host, port);
        try {
            InetSocketAddress addr = server.getListenerAddress();
            TestHttpServer.assertEquals((long)port, (long)addr.getPort());
            server.openListener();
            addr = server.getListenerAddress();
            TestHttpServer.assertEquals((Object)host, (Object)addr.getHostName());
            int boundPort = addr.getPort();
            if (port == 0) {
                TestHttpServer.assertTrue((boundPort != 0 ? 1 : 0) != 0);
            } else if (findPort) {
                TestHttpServer.assertTrue((boundPort > port ? 1 : 0) != 0);
                TestHttpServer.assertTrue((addr.getPort() - port < 8 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            server.stop();
            throw e;
        }
        return server;
    }

    public static class MyGroupsProvider
    extends ShellBasedUnixGroupsMapping {
        static Map<String, List<String>> mapping = new HashMap<String, List<String>>();

        static void clearMapping() {
            mapping.clear();
        }

        public List<String> getGroups(String user) throws IOException {
            return mapping.get(user);
        }
    }

    public static class DummyFilterInitializer
    extends FilterInitializer {
        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("DummyFilter", DummyServletFilter.class.getName(), null);
        }
    }

    public static class DummyServletFilter
    implements Filter {
        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            final String userName = request.getParameter("user.name");
            HttpServletRequestWrapper requestModified = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getRemoteUser() {
                    return userName;
                }
            };
            filterChain.doFilter((ServletRequest)requestModified, response);
        }

        public void init(FilterConfig arg0) throws ServletException {
        }
    }

    public static class HtmlContentServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.print("hello world");
            out.close();
        }
    }

    public static class EchoServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            TreeSet sortedKeys = new TreeSet();
            Enumeration keys = request.getParameterNames();
            while (keys.hasMoreElements()) {
                sortedKeys.add(keys.nextElement());
            }
            for (String key : sortedKeys) {
                out.print(key);
                out.print(':');
                out.print(request.getParameter(key));
                out.print('\n');
            }
            out.close();
        }
    }

    public static class EchoMapServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            Map params = request.getParameterMap();
            TreeSet keys = new TreeSet(params.keySet());
            for (String key : keys) {
                out.print(key);
                out.print(':');
                String[] values = (String[])params.get(key);
                if (values.length > 0) {
                    out.print(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        out.print(',');
                        out.print(values[i]);
                    }
                }
                out.print('\n');
            }
            out.close();
        }
    }
}

