/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSSLHttpServer
extends HttpServerFunctionalTest {
    private static final String CONFIG_SITE_XML = "sslhttpserver-site.xml";
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestSSLHttpServer.class.getSimpleName();
    static final Log LOG = LogFactory.getLog(TestSSLHttpServer.class);
    private static HttpServer server;
    private static URL baseUrl;

    @Before
    public void setup() throws Exception {
        HttpConfig.setSecure((boolean)true);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        String classpathDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        Configuration conf = new Configuration();
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        String sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfsDir, conf, false);
        conf.setBoolean("hadoop.ssl.enabled", true);
        FileWriter writer = new FileWriter(new File(classpathDir, CONFIG_SITE_XML));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        conf.setInt("hadoop.http.max.threads", 10);
        conf.addResource(CONFIG_SITE_XML);
        server = TestSSLHttpServer.createServer("test", conf);
        server.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.start();
        baseUrl = new URL("https://localhost:" + server.getPort() + "/");
        LOG.info((Object)("HTTP server started: " + baseUrl));
    }

    @After
    public void cleanup() throws Exception {
        server.stop();
        String classpathDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        new File(classpathDir, CONFIG_SITE_XML).delete();
        HttpConfig.setSecure((boolean)false);
    }

    @Test
    public void testEcho() throws Exception {
        TestSSLHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c=d")));
        TestSSLHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    private static String readOut(URL url) throws Exception {
        StringBuilder out = new StringBuilder();
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        Configuration conf = new Configuration();
        conf.addResource(CONFIG_SITE_XML);
        SSLFactory sslf = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslf.init();
        conn.setSSLSocketFactory(sslf.createSSLSocketFactory());
        InputStream in = conn.getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }
}

