/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Random;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestIPC {
    public static final Log LOG = LogFactory.getLog(TestIPC.class);
    private static final Configuration conf = new Configuration();
    private static final int PING_INTERVAL = 1000;
    private static final int MIN_SLEEP_TIME = 1000;
    static boolean WRITABLE_FAULTS_ENABLED = true;
    private static final Random RANDOM;
    private static final String ADDRESS = "0.0.0.0";
    private static final File FD_DIR;

    @Test
    public void testSerial() throws Exception {
        this.testSerial(3, false, 2, 5, 100);
        this.testSerial(3, true, 2, 5, 10);
    }

    public void testSerial(int handlerCount, boolean handlerSleep, int clientCount, int callerCount, int callCount) throws Exception {
        int i;
        TestServer server = new TestServer(handlerCount, handlerSleep);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        Client[] clients = new Client[clientCount];
        for (int i2 = 0; i2 < clientCount; ++i2) {
            clients[i2] = new Client(LongWritable.class, conf);
        }
        SerialCaller[] callers = new SerialCaller[callerCount];
        for (i = 0; i < callerCount; ++i) {
            callers[i] = new SerialCaller(clients[i % clientCount], addr, callCount);
            callers[i].start();
        }
        for (i = 0; i < callerCount; ++i) {
            callers[i].join();
            Assert.assertFalse((boolean)callers[i].failed);
        }
        for (i = 0; i < clientCount; ++i) {
            clients[i].stop();
        }
        server.stop();
    }

    @Test
    public void testStandAloneClient() throws Exception {
        Client client = new Client(LongWritable.class, conf);
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 10);
        try {
            client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
            Assert.fail((String)"Expected an exception to have been thrown");
        }
        catch (IOException e) {
            String message = e.getMessage();
            String addressText = address.getHostName() + ":" + address.getPort();
            Assert.assertTrue((String)("Did not find " + addressText + " in " + message), (boolean)message.contains(addressText));
            Throwable cause = e.getCause();
            Assert.assertNotNull((String)("No nested exception in " + e), (Object)cause);
            String causeText = cause.getMessage();
            Assert.assertTrue((String)("Did not find " + causeText + " in " + message), (boolean)message.contains(causeText));
        }
    }

    static void maybeThrowIOE() throws IOException {
        if (WRITABLE_FAULTS_ENABLED) {
            throw new IOException("Injected fault");
        }
    }

    static void maybeThrowRTE() {
        if (WRITABLE_FAULTS_ENABLED) {
            throw new RuntimeException("Injected fault");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doErrorTest(Class<? extends LongWritable> clientParamClass, Class<? extends LongWritable> serverParamClass, Class<? extends LongWritable> serverResponseClass, Class<? extends LongWritable> clientResponseClass) throws Exception {
        TestServer server = new TestServer(1, false, serverParamClass, serverResponseClass);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        WRITABLE_FAULTS_ENABLED = true;
        Client client = new Client(clientResponseClass, conf);
        try {
            LongWritable param = clientParamClass.newInstance();
            try {
                client.call((Writable)param, addr, null, null, 0, conf);
                Assert.fail((String)"Expected an exception to have been thrown");
            }
            catch (Throwable t) {
                TestIPC.assertExceptionContains(t, "Injected fault");
            }
            WRITABLE_FAULTS_ENABLED = false;
            client.call((Writable)param, addr, null, null, 0, conf);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testIOEOnClientWriteParam() throws Exception {
        this.doErrorTest(IOEOnWriteWritable.class, LongWritable.class, LongWritable.class, LongWritable.class);
    }

    @Test
    public void testRTEOnClientWriteParam() throws Exception {
        this.doErrorTest(RTEOnWriteWritable.class, LongWritable.class, LongWritable.class, LongWritable.class);
    }

    @Test
    public void testIOEOnServerReadParam() throws Exception {
        this.doErrorTest(LongWritable.class, IOEOnReadWritable.class, LongWritable.class, LongWritable.class);
    }

    @Test
    public void testRTEOnServerReadParam() throws Exception {
        this.doErrorTest(LongWritable.class, RTEOnReadWritable.class, LongWritable.class, LongWritable.class);
    }

    @Test
    public void testIOEOnServerWriteResponse() throws Exception {
        this.doErrorTest(LongWritable.class, LongWritable.class, IOEOnWriteWritable.class, LongWritable.class);
    }

    @Test
    public void testRTEOnServerWriteResponse() throws Exception {
        this.doErrorTest(LongWritable.class, LongWritable.class, RTEOnWriteWritable.class, LongWritable.class);
    }

    @Test
    public void testIOEOnClientReadResponse() throws Exception {
        this.doErrorTest(LongWritable.class, LongWritable.class, LongWritable.class, IOEOnReadWritable.class);
    }

    @Test
    public void testRTEOnClientReadResponse() throws Exception {
        this.doErrorTest(LongWritable.class, LongWritable.class, LongWritable.class, RTEOnReadWritable.class);
    }

    private static void assertExceptionContains(Throwable t, String substring) {
        String msg = StringUtils.stringifyException((Throwable)t);
        Assert.assertTrue((String)("Exception should contain substring '" + substring + "':\n" + msg), (boolean)msg.contains(substring));
        LOG.info((Object)"Got expected exception", t);
    }

    @Test
    public void testSocketFactoryException() throws Exception {
        SocketFactory mockFactory = (SocketFactory)Mockito.mock(SocketFactory.class);
        ((SocketFactory)Mockito.doThrow((Throwable)new IOException("Injected fault")).when((Object)mockFactory)).createSocket();
        Client client = new Client(LongWritable.class, conf, mockFactory);
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 10);
        try {
            client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
            Assert.fail((String)"Expected an exception to have been thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Injected fault"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRTEDuringConnectionSetup() throws Exception {
        SocketFactory spyFactory = (SocketFactory)Mockito.spy((Object)NetUtils.getDefaultSocketFactory((Configuration)conf));
        ((SocketFactory)Mockito.doAnswer((Answer)new Answer<Socket>(){

            public Socket answer(InvocationOnMock invocation) throws Throwable {
                Socket s = (Socket)Mockito.spy((Object)((Socket)invocation.callRealMethod()));
                ((Socket)Mockito.doThrow((Throwable)new RuntimeException("Injected fault")).when((Object)s)).setSoTimeout(Mockito.anyInt());
                return s;
            }
        }).when((Object)spyFactory)).createSocket();
        TestServer server = new TestServer(1, true);
        server.start();
        try {
            InetSocketAddress address = NetUtils.getConnectAddress((Server)server);
            Client client = new Client(LongWritable.class, conf, spyFactory);
            try {
                client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
                Assert.fail((String)"Expected an exception to have been thrown");
            }
            catch (Exception e) {
                LOG.info((Object)"caught expected exception", (Throwable)e);
                Assert.assertTrue((boolean)StringUtils.stringifyException((Throwable)e).contains("Injected fault"));
            }
            Mockito.reset((Object[])new SocketFactory[]{spyFactory});
            client.call((Writable)new LongWritable(RANDOM.nextLong()), address, null, null, 0, conf);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testIpcTimeout() throws Exception {
        TestServer server = new TestServer(1, true);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        Client client = new Client(LongWritable.class, conf);
        try {
            client.call((Writable)new LongWritable(RANDOM.nextLong()), addr, null, null, 500, conf);
            Assert.fail((String)"Expected an exception to have been thrown");
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"Get a SocketTimeoutException ", (Throwable)e);
        }
        client.call((Writable)new LongWritable(RANDOM.nextLong()), addr, null, null, 4000, conf);
    }

    @Test
    public void testSocketLeak() throws Exception {
        Assume.assumeTrue((boolean)FD_DIR.exists());
        long startFds = this.countOpenFileDescriptors();
        for (int i = 0; i < 50; ++i) {
            TestServer server = new TestServer(1, true);
            server.start();
            server.stop();
        }
        long endFds = this.countOpenFileDescriptors();
        Assert.assertTrue((String)("Leaked " + (endFds - startFds) + " file descriptors"), (endFds - startFds < 20L ? 1 : 0) != 0);
    }

    private long countOpenFileDescriptors() {
        return FD_DIR.list().length;
    }

    @Test
    public void testIpcFromHadoop_0_18_13() throws Exception {
        this.doIpcVersionTest(NetworkTraces.HADOOP_0_18_3_RPC_DUMP, NetworkTraces.RESPONSE_TO_HADOOP_0_18_3_RPC);
    }

    @Test
    public void testIpcFromHadoop0_20_3() throws Exception {
        this.doIpcVersionTest(NetworkTraces.HADOOP_0_20_3_RPC_DUMP, NetworkTraces.RESPONSE_TO_HADOOP_0_20_3_RPC);
    }

    @Test
    public void testIpcFromHadoop0_21_0() throws Exception {
        this.doIpcVersionTest(NetworkTraces.HADOOP_0_21_0_RPC_DUMP, NetworkTraces.RESPONSE_TO_HADOOP_0_21_0_RPC);
    }

    @Test
    public void testHttpGetResponse() throws Exception {
        this.doIpcVersionTest("GET / HTTP/1.0\r\n\r\n".getBytes(), "HTTP/1.1 404 Not Found\r\nContent-type: text/plain\r\n\r\nIt looks like you are making an HTTP request to a Hadoop IPC port. This is not the correct port for the web interface on this daemon.\r\n".getBytes());
    }

    @Test
    public void testConnectionRetriesOnSocketTimeoutExceptions() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("ipc.client.connect.max.retries.on.timeouts", 0);
        this.assertRetriesOnSocketTimeouts(conf, 1);
        conf.setInt("ipc.client.connect.max.retries.on.timeouts", 3);
        this.assertRetriesOnSocketTimeouts(conf, 4);
    }

    private void assertRetriesOnSocketTimeouts(Configuration conf, int maxTimeoutRetries) throws IOException, InterruptedException {
        SocketFactory mockFactory = (SocketFactory)Mockito.mock(SocketFactory.class);
        ((SocketFactory)Mockito.doThrow((Throwable)new SocketTimeoutException()).when((Object)mockFactory)).createSocket();
        Client client = new Client(IntWritable.class, conf, mockFactory);
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9090);
        try {
            client.call((Writable)new IntWritable(RANDOM.nextInt()), address, null, null, 0, conf);
            Assert.fail((String)"Not throwing the SocketTimeoutException");
        }
        catch (SocketTimeoutException e) {
            ((SocketFactory)Mockito.verify((Object)mockFactory, (VerificationMode)Mockito.times((int)maxTimeoutRetries))).createSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIpcVersionTest(byte[] requestData, byte[] expectedResponse) throws Exception {
        TestServer server = new TestServer(1, true);
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        server.start();
        Socket socket = new Socket();
        try {
            NetUtils.connect((Socket)socket, (SocketAddress)addr, (int)5000);
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            out.write(requestData, 0, requestData.length);
            out.flush();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)baos, (int)256);
            byte[] responseData = baos.toByteArray();
            Assert.assertEquals((Object)StringUtils.byteToHexString((byte[])expectedResponse), (Object)StringUtils.byteToHexString((byte[])responseData));
        }
        finally {
            IOUtils.closeSocket((Socket)socket);
            server.stop();
        }
    }

    private static byte[] hexDumpToBytes(String hexdump) {
        int LAST_HEX_COL = 48;
        StringBuilder hexString = new StringBuilder();
        for (String line : hexdump.toUpperCase().split("\n")) {
            hexString.append(line.substring(0, 48).replace(" ", ""));
        }
        return StringUtils.hexStringToByte((String)hexString.toString());
    }

    static /* synthetic */ byte[] access$300(String x0) {
        return TestIPC.hexDumpToBytes(x0);
    }

    static {
        Client.setPingInterval((Configuration)conf, (int)1000);
        RANDOM = new Random();
        FD_DIR = new File("/proc/self/fd");
    }

    private static abstract class NetworkTraces {
        static final byte[] HADOOP_0_18_3_RPC_DUMP = TestIPC.access$300("68 72 70 63 02 00 00 00  82 00 1d 6f 72 67 2e 61 hrpc.... ...org.a\n70 61 63 68 65 2e 68 61  64 6f 6f 70 2e 69 6f 2e pache.ha doop.io.\n57 72 69 74 61 62 6c 65  00 30 6f 72 67 2e 61 70 Writable .0org.ap\n61 63 68 65 2e 68 61 64  6f 6f 70 2e 69 6f 2e 4f ache.had oop.io.O\n62 6a 65 63 74 57 72 69  74 61 62 6c 65 24 4e 75 bjectWri table$Nu\n6c 6c 49 6e 73 74 61 6e  63 65 00 2f 6f 72 67 2e llInstan ce./org.\n61 70 61 63 68 65 2e 68  61 64 6f 6f 70 2e 73 65 apache.h adoop.se\n63 75 72 69 74 79 2e 55  73 65 72 47 72 6f 75 70 curity.U serGroup\n49 6e 66 6f 72 6d 61 74  69 6f 6e 00 00 00 6c 00 Informat ion...l.\n00 00 00 00 12 67 65 74  50 72 6f 74 6f 63 6f 6c .....get Protocol\n56 65 72 73 69 6f 6e 00  00 00 02 00 10 6a 61 76 Version. .....jav\n61 2e 6c 61 6e 67 2e 53  74 72 69 6e 67 00 2e 6f a.lang.S tring..o\n72 67 2e 61 70 61 63 68  65 2e 68 61 64 6f 6f 70 rg.apach e.hadoop\n2e 6d 61 70 72 65 64 2e  4a 6f 62 53 75 62 6d 69 .mapred. JobSubmi\n73 73 69 6f 6e 50 72 6f  74 6f 63 6f 6c 00 04 6c ssionPro tocol..l\n6f 6e 67 00 00 00 00 00  00 00 0a                ong..... ...     \n");
        static final String HADOOP0_18_ERROR_MSG = "Server IPC version 7 cannot communicate with client version 2";
        static final byte[] RESPONSE_TO_HADOOP_0_18_3_RPC = Bytes.concat((byte[][])new byte[][]{TestIPC.access$300("00 00 00 00 01 00 00 00  29 6f 72 67 2e 61 70 61 ........ )org.apa\n63 68 65 2e 68 61 64 6f  6f 70 2e 69 70 63 2e 52 che.hado op.ipc.R\n50 43 24 56 65 72 73 69  6f 6e 4d 69 73 6d 61 74 PC$Versi onMismat\n63 68                                            ch               \n"), Ints.toByteArray((int)"Server IPC version 7 cannot communicate with client version 2".length()), "Server IPC version 7 cannot communicate with client version 2".getBytes()});
        static final byte[] HADOOP_0_20_3_RPC_DUMP = TestIPC.access$300("68 72 70 63 03 00 00 00  79 27 6f 72 67 2e 61 70 hrpc.... y'org.ap\n61 63 68 65 2e 68 61 64  6f 6f 70 2e 69 70 63 2e ache.had oop.ipc.\n56 65 72 73 69 6f 6e 65  64 50 72 6f 74 6f 63 6f Versione dProtoco\n6c 01 0a 53 54 52 49 4e  47 5f 55 47 49 04 74 6f l..STRIN G_UGI.to\n64 64 09 04 74 6f 64 64  03 61 64 6d 07 64 69 61 dd..todd .adm.dia\n6c 6f 75 74 05 63 64 72  6f 6d 07 70 6c 75 67 64 lout.cdr om.plugd\n65 76 07 6c 70 61 64 6d  69 6e 05 61 64 6d 69 6e ev.lpadm in.admin\n0a 73 61 6d 62 61 73 68  61 72 65 06 6d 72 74 65 .sambash are.mrte\n73 74 00 00 00 6c 00 00  00 00 00 12 67 65 74 50 st...l.. ....getP\n72 6f 74 6f 63 6f 6c 56  65 72 73 69 6f 6e 00 00 rotocolV ersion..\n00 02 00 10 6a 61 76 61  2e 6c 61 6e 67 2e 53 74 ....java .lang.St\n72 69 6e 67 00 2e 6f 72  67 2e 61 70 61 63 68 65 ring..or g.apache\n2e 68 61 64 6f 6f 70 2e  6d 61 70 72 65 64 2e 4a .hadoop. mapred.J\n6f 62 53 75 62 6d 69 73  73 69 6f 6e 50 72 6f 74 obSubmis sionProt\n6f 63 6f 6c 00 04 6c 6f  6e 67 00 00 00 00 00 00 ocol..lo ng......\n00 14                                            ..               \n");
        static final String HADOOP0_20_ERROR_MSG = "Server IPC version 7 cannot communicate with client version 3";
        static final byte[] RESPONSE_TO_HADOOP_0_20_3_RPC = Bytes.concat((byte[][])new byte[][]{TestIPC.access$300("ff ff ff ff ff ff ff ff  00 00 00 29 6f 72 67 2e ........ ...)org.\n61 70 61 63 68 65 2e 68  61 64 6f 6f 70 2e 69 70 apache.h adoop.ip\n63 2e 52 50 43 24 56 65  72 73 69 6f 6e 4d 69 73 c.RPC$Ve rsionMis\n6d 61 74 63 68                                   match            \n"), Ints.toByteArray((int)"Server IPC version 7 cannot communicate with client version 3".length()), "Server IPC version 7 cannot communicate with client version 3".getBytes()});
        static final String HADOOP0_21_ERROR_MSG = "Server IPC version 7 cannot communicate with client version 4";
        static final byte[] HADOOP_0_21_0_RPC_DUMP = TestIPC.access$300("68 72 70 63 04 50                                hrpc.P00 00 00 3c 33 6f 72 67  2e 61 70 61 63 68 65 2e ...<3org .apache.\n68 61 64 6f 6f 70 2e 6d  61 70 72 65 64 75 63 65 hadoop.m apreduce\n2e 70 72 6f 74 6f 63 6f  6c 2e 43 6c 69 65 6e 74 .protoco l.Client\n50 72 6f 74 6f 63 6f 6c  01 00 04 74 6f 64 64 00 Protocol ...todd.\n00 00 00 71 00 00 00 00  00 12 67 65 74 50 72 6f ...q.... ..getPro\n74 6f 63 6f 6c 56 65 72  73 69 6f 6e 00 00 00 02 tocolVer sion....\n00 10 6a 61 76 61 2e 6c  61 6e 67 2e 53 74 72 69 ..java.l ang.Stri\n6e 67 00 33 6f 72 67 2e  61 70 61 63 68 65 2e 68 ng.3org. apache.h\n61 64 6f 6f 70 2e 6d 61  70 72 65 64 75 63 65 2e adoop.ma preduce.\n70 72 6f 74 6f 63 6f 6c  2e 43 6c 69 65 6e 74 50 protocol .ClientP\n72 6f 74 6f 63 6f 6c 00  04 6c 6f 6e 67 00 00 00 rotocol. .long...\n00 00 00 00 21                                   ....!            \n");
        static final byte[] RESPONSE_TO_HADOOP_0_21_0_RPC = Bytes.concat((byte[][])new byte[][]{TestIPC.access$300("ff ff ff ff ff ff ff ff  00 00 00 29 6f 72 67 2e ........ ...)org.\n61 70 61 63 68 65 2e 68  61 64 6f 6f 70 2e 69 70 apache.h adoop.ip\n63 2e 52 50 43 24 56 65  72 73 69 6f 6e 4d 69 73 c.RPC$Ve rsionMis\n6d 61 74 63 68                                   match            \n"), Ints.toByteArray((int)"Server IPC version 7 cannot communicate with client version 4".length()), "Server IPC version 7 cannot communicate with client version 4".getBytes()});

        private NetworkTraces() {
        }
    }

    private static class RTEOnWriteWritable
    extends LongWritable {
        public void write(DataOutput out) throws IOException {
            super.write(out);
            TestIPC.maybeThrowRTE();
        }
    }

    private static class IOEOnWriteWritable
    extends LongWritable {
        public void write(DataOutput out) throws IOException {
            super.write(out);
            TestIPC.maybeThrowIOE();
        }
    }

    private static class RTEOnReadWritable
    extends LongWritable {
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            TestIPC.maybeThrowRTE();
        }
    }

    private static class IOEOnReadWritable
    extends LongWritable {
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            TestIPC.maybeThrowIOE();
        }
    }

    private static class SerialCaller
    extends Thread {
        private Client client;
        private InetSocketAddress server;
        private int count;
        private boolean failed;

        public SerialCaller(Client client, InetSocketAddress server, int count) {
            this.client = client;
            this.server = server;
            this.count = count;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    LongWritable param = new LongWritable(RANDOM.nextLong());
                    LongWritable value = (LongWritable)this.client.call((Writable)param, this.server, null, null, 0, conf);
                    if (param.equals((Object)value)) continue;
                    LOG.fatal((Object)"Call failed!");
                    this.failed = true;
                    break;
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Caught: " + StringUtils.stringifyException((Throwable)e)));
                    this.failed = true;
                }
            }
        }
    }

    private static class TestServer
    extends Server {
        private boolean sleep;
        private Class<? extends Writable> responseClass;

        public TestServer(int handlerCount, boolean sleep) throws IOException {
            this(handlerCount, sleep, LongWritable.class, null);
        }

        public TestServer(int handlerCount, boolean sleep, Class<? extends Writable> paramClass, Class<? extends Writable> responseClass) throws IOException {
            super(TestIPC.ADDRESS, 0, paramClass, handlerCount, conf);
            this.sleep = sleep;
            this.responseClass = responseClass;
        }

        public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws IOException {
            if (this.sleep) {
                try {
                    Thread.sleep(RANDOM.nextInt(1000) + 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.responseClass != null) {
                try {
                    return this.responseClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return param;
        }
    }
}

