/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;

public class TestIPCServerResponder
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestIPCServerResponder.class);
    private static Configuration conf = new Configuration();
    private static final Random RANDOM = new Random();
    private static final String ADDRESS = "0.0.0.0";
    private static final int BYTE_COUNT = 1024;
    private static final byte[] BYTES = new byte[1024];

    public TestIPCServerResponder(String name) {
        super(name);
    }

    public void testResponseBuffer() throws Exception {
        Server.INITIAL_RESP_BUF_SIZE = 1;
        conf.setInt("ipc.server.max.response.size", 1);
        this.testServerResponder(1, true, 1, 1, 5);
        conf = new Configuration();
    }

    public void testServerResponder() throws Exception {
        this.testServerResponder(10, true, 1, 10, 200);
    }

    public void testServerResponder(int handlerCount, boolean handlerSleep, int clientCount, int callerCount, int callCount) throws Exception {
        int i;
        TestServer server = new TestServer(handlerCount, handlerSleep);
        server.start();
        InetSocketAddress address = NetUtils.getConnectAddress((Server)server);
        Client[] clients = new Client[clientCount];
        for (int i2 = 0; i2 < clientCount; ++i2) {
            clients[i2] = new Client(BytesWritable.class, conf);
        }
        Caller[] callers = new Caller[callerCount];
        for (i = 0; i < callerCount; ++i) {
            callers[i] = new Caller(clients[i % clientCount], address, callCount);
            callers[i].start();
        }
        for (i = 0; i < callerCount; ++i) {
            callers[i].join();
            TestIPCServerResponder.assertFalse((boolean)callers[i].failed);
        }
        for (i = 0; i < clientCount; ++i) {
            clients[i].stop();
        }
        server.stop();
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            TestIPCServerResponder.BYTES[i] = (byte)(97 + i % 26);
        }
    }

    private static class Caller
    extends Thread {
        private Client client;
        private int count;
        private InetSocketAddress address;
        private boolean failed;

        public Caller(Client client, InetSocketAddress address, int count) {
            this.client = client;
            this.address = address;
            this.count = count;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                try {
                    int byteSize = RANDOM.nextInt(1024);
                    byte[] bytes = new byte[byteSize];
                    System.arraycopy(BYTES, 0, bytes, 0, byteSize);
                    BytesWritable param = new BytesWritable(bytes);
                    Writable value = this.client.call((Writable)param, this.address);
                    Thread.sleep(RANDOM.nextInt(20));
                    continue;
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Caught: " + e));
                    this.failed = true;
                }
            }
        }
    }

    private static class TestServer
    extends Server {
        private boolean sleep;

        public TestServer(int handlerCount, boolean sleep) throws IOException {
            super(TestIPCServerResponder.ADDRESS, 0, BytesWritable.class, handlerCount, conf);
            this.setSocketSendBufSize(512);
            this.sleep = sleep;
        }

        public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws IOException {
            if (this.sleep) {
                try {
                    Thread.sleep(RANDOM.nextInt(20));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return param;
        }
    }
}

