/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProtoBufRpc {
    public static final String ADDRESS = "0.0.0.0";
    public static final int PORT = 0;
    private static InetSocketAddress addr;
    private static Configuration conf;
    private static RPC.Server server;

    @Before
    public void setUp() throws IOException {
        conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, TestRpcService.class, ProtobufRpcEngine.class);
        PBServerImpl serverImpl = new PBServerImpl();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(serverImpl);
        server = RPC.getServer(TestRpcService.class, (Object)service, (String)ADDRESS, (int)0, (Configuration)conf);
        addr = NetUtils.getConnectAddress((Server)server);
        PBServer2Impl server2Impl = new PBServer2Impl();
        BlockingService service2 = TestRpcServiceProtos.TestProtobufRpc2Proto.newReflectiveBlockingService(server2Impl);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, TestRpcService2.class, (Object)service2);
        server.start();
    }

    @After
    public void tearDown() throws Exception {
        server.stop();
    }

    private static TestRpcService getClient() throws IOException {
        RPC.setProtocolEngine((Configuration)conf, TestRpcService.class, ProtobufRpcEngine.class);
        return (TestRpcService)RPC.getProxy(TestRpcService.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
    }

    private static TestRpcService2 getClient2() throws IOException {
        RPC.setProtocolEngine((Configuration)conf, TestRpcService2.class, ProtobufRpcEngine.class);
        return (TestRpcService2)RPC.getProxy(TestRpcService2.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Test
    public void testProtoBufRpc() throws Exception {
        TestRpcService client = TestProtoBufRpc.getClient();
        TestProtoBufRpc.testProtoBufRpc(client);
    }

    public static void testProtoBufRpc(TestRpcService client) throws Exception {
        TestProtos.EmptyRequestProto emptyRequest = TestProtos.EmptyRequestProto.newBuilder().build();
        client.ping(null, emptyRequest);
        TestProtos.EchoRequestProto echoRequest = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
        TestProtos.EchoResponseProto echoResponse = client.echo(null, echoRequest);
        Assert.assertEquals((Object)echoResponse.getMessage(), (Object)"hello");
        try {
            client.error(null, emptyRequest);
            Assert.fail((String)"Expected exception is not thrown");
        }
        catch (ServiceException e) {
            RemoteException re = (RemoteException)e.getCause();
            RpcServerException rse = (RpcServerException)re.unwrapRemoteException(new Class[]{RpcServerException.class});
        }
    }

    @Test
    public void testProtoBufRpc2() throws Exception {
        TestRpcService2 client = TestProtoBufRpc.getClient2();
        TestProtos.EmptyRequestProto emptyRequest = TestProtos.EmptyRequestProto.newBuilder().build();
        client.ping2(null, emptyRequest);
        TestProtos.EchoRequestProto echoRequest = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
        TestProtos.EchoResponseProto echoResponse = client.echo2(null, echoRequest);
        Assert.assertEquals((Object)echoResponse.getMessage(), (Object)"hello");
        MetricsRecordBuilder rpcMetrics = MetricsAsserts.getMetrics(server.getRpcMetrics().name());
        MetricsAsserts.assertCounterGt("RpcQueueTimeNumOps", 0L, rpcMetrics);
        MetricsAsserts.assertCounterGt("RpcProcessingTimeNumOps", 0L, rpcMetrics);
        MetricsRecordBuilder rpcDetailedMetrics = MetricsAsserts.getMetrics(server.getRpcDetailedMetrics().name());
        MetricsAsserts.assertCounterGt("Echo2NumOps", 0L, rpcDetailedMetrics);
    }

    public static class PBServer2Impl
    implements TestRpcService2 {
        @Override
        public TestProtos.EmptyResponseProto ping2(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EchoResponseProto echo2(RpcController unused, TestProtos.EchoRequestProto request) throws ServiceException {
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }
    }

    public static class PBServerImpl
    implements TestRpcService {
        @Override
        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EchoResponseProto echo(RpcController unused, TestProtos.EchoRequestProto request) throws ServiceException {
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }

        @Override
        public TestProtos.EmptyResponseProto error(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            throw new ServiceException("error", (Throwable)new RpcServerException("error"));
        }
    }

    @ProtocolInfo(protocolName="testProto2", protocolVersion=1L)
    public static interface TestRpcService2
    extends TestRpcServiceProtos.TestProtobufRpc2Proto.BlockingInterface {
    }

    @ProtocolInfo(protocolName="testProto", protocolVersion=1L)
    public static interface TestRpcService
    extends TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface {
    }
}

