/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.HashMap;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StandardSocketFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestSocketFactory {
    @Test
    public void testSocketFactoryAsKeyInMap() throws Exception {
        HashMap<SocketFactory, Integer> dummyCache = new HashMap<SocketFactory, Integer>();
        int toBeCached1 = 1;
        int toBeCached2 = 2;
        Configuration conf = new Configuration();
        conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.ipc.TestSocketFactory$DummySocketFactory");
        SocketFactory dummySocketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        dummyCache.put(dummySocketFactory, toBeCached1);
        conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.StandardSocketFactory");
        SocketFactory defaultSocketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        dummyCache.put(defaultSocketFactory, toBeCached2);
        junit.framework.Assert.assertEquals((String)"The cache contains two elements", (int)2, (int)dummyCache.size());
        junit.framework.Assert.assertEquals((String)"Equals of both socket factory shouldn't be same", (boolean)defaultSocketFactory.equals(dummySocketFactory), (boolean)false);
        Assert.assertSame((Object)toBeCached2, dummyCache.remove(defaultSocketFactory));
        dummyCache.put(defaultSocketFactory, toBeCached2);
        Assert.assertSame((Object)toBeCached1, dummyCache.remove(dummySocketFactory));
    }

    static class DummySocketFactory
    extends StandardSocketFactory {
        DummySocketFactory() {
        }
    }
}

