/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricGaugeInt;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.apache.hadoop.metrics2.impl.MetricsLists;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.test.MoreAsserts;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetricsSystemImpl {
    private static final Log LOG = LogFactory.getLog(TestMetricsSystemImpl.class);
    @Captor
    private ArgumentCaptor<MetricsRecord> r1;
    @Captor
    private ArgumentCaptor<MetricsRecord> r2;
    private static String hostname = MetricsSystemImpl.getHostname();

    @Test
    public void testInitFirst() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add("*.period", 8).add("test.sink.test.class", TestSink.class.getName()).add("test.*.source.filter.exclude", "s0").add("test.source.s1.metric.filter.exclude", "X*").add("test.sink.sink1.metric.filter.exclude", "Y*").add("test.sink.sink2.metric.filter.exclude", "Y*").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        ms.register("s0", "s0 desc", (Object)new TestSource("s0rec"));
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (Object)new TestSource("s1rec"));
        s1.c1.incr();
        s1.xxx.incr();
        s1.g1.set(2L);
        s1.yyy.incr(2L);
        s1.s1.add(0L);
        MetricsSink sink1 = (MetricsSink)Mockito.mock(MetricsSink.class);
        MetricsSink sink2 = (MetricsSink)Mockito.mock(MetricsSink.class);
        ms.registerSink("sink1", "sink1 desc", sink1);
        ms.registerSink("sink2", "sink2 desc", sink2);
        ms.onTimerEvent();
        ms.stop();
        ((MetricsSink)Mockito.verify((Object)sink1, (VerificationMode)Mockito.times((int)2))).putMetrics((MetricsRecord)this.r1.capture());
        List mr1 = this.r1.getAllValues();
        ((MetricsSink)Mockito.verify((Object)sink2, (VerificationMode)Mockito.times((int)2))).putMetrics((MetricsRecord)this.r2.capture());
        List mr2 = this.r2.getAllValues();
        this.checkMetricsRecords(mr1);
        MoreAsserts.assertEquals("output", mr1, mr2);
    }

    @Test
    public void testRegisterDups() {
        MetricsSystemImpl ms = new MetricsSystemImpl();
        TestSource ts1 = new TestSource("ts1");
        TestSource ts2 = new TestSource("ts2");
        ms.register("ts1", "", (Object)ts1);
        MetricsSource s1 = ms.getSource("ts1");
        Assert.assertNotNull((Object)s1);
        ms.register("ts1", "", (Object)ts2);
        MetricsSource s2 = ms.getSource("ts1");
        Assert.assertNotNull((Object)s2);
        Assert.assertNotSame((Object)s1, (Object)s2);
    }

    @Test(expected=MetricsException.class)
    public void testRegisterDupError() {
        MetricsSystemImpl ms = new MetricsSystemImpl("test");
        TestSource ts = new TestSource("ts");
        ms.register((Object)ts);
        ms.register((Object)ts);
    }

    private void checkMetricsRecords(List<MetricsRecord> recs) {
        LOG.debug(recs);
        MetricsRecord r = recs.get(0);
        Assert.assertEquals((String)"name", (Object)"s1rec", (Object)r.name());
        MoreAsserts.assertEquals("tags", new MetricsTag[]{Interns.tag((MetricsInfo)MsInfo.Context, (String)"test"), Interns.tag((MetricsInfo)MsInfo.Hostname, (String)hostname)}, r.tags());
        MoreAsserts.assertEquals("metrics", MetricsLists.builder("").addCounter(Interns.info((String)"C1", (String)"C1 desc"), 1L).addGauge(Interns.info((String)"G1", (String)"G1 desc"), 2L).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for s1"), 1L).addGauge(Interns.info((String)"S1AvgTime", (String)"Average time for s1"), 0.0).metrics(), r.metrics());
        r = recs.get(1);
        Assert.assertTrue((String)"NumActiveSinks should be 3", (boolean)Iterables.contains((Iterable)r.metrics(), (Object)new MetricGaugeInt((MetricsInfo)MsInfo.NumActiveSinks, 3)));
    }

    private static String getPluginUrlsAsString() {
        return "file:metrics2-test-plugin.jar";
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        @Metric(value={"XXX desc"})
        MutableCounterLong xxx;
        @Metric(value={"G1 desc"})
        MutableGaugeLong g1;
        @Metric(value={"YYY desc"})
        MutableGaugeLong yyy;
        @Metric
        MutableRate s1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }
    }

    public static class TestSink
    implements MetricsSink {
        public void putMetrics(MetricsRecord record) {
            LOG.debug((Object)record);
        }

        public void flush() {
        }

        public void init(SubsetConfiguration conf) {
            LOG.debug((Object)MetricsConfig.toString((Configuration)conf));
        }
    }
}

