/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestSwitchMapping
extends Assert {
    @Test
    public void testStandaloneClassesAssumedMultiswitch() throws Throwable {
        StandaloneSwitchMapping mapping = new StandaloneSwitchMapping();
        TestSwitchMapping.assertFalse((String)("Expected to be multi switch " + mapping), (boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping));
    }

    @Test
    public void testCachingRelays() throws Throwable {
        CachedDNSToSwitchMapping mapping = new CachedDNSToSwitchMapping((DNSToSwitchMapping)new StandaloneSwitchMapping());
        TestSwitchMapping.assertFalse((String)("Expected to be multi switch " + mapping), (boolean)mapping.isSingleSwitch());
    }

    @Test
    public void testCachingRelaysStringOperations() throws Throwable {
        Configuration conf = new Configuration();
        String scriptname = "mappingscript.sh";
        conf.set("net.topology.script.file.name", scriptname);
        ScriptBasedMapping scriptMapping = new ScriptBasedMapping(conf);
        TestSwitchMapping.assertTrue((String)("Did not find " + scriptname + " in " + scriptMapping), (boolean)scriptMapping.toString().contains(scriptname));
        CachedDNSToSwitchMapping mapping = new CachedDNSToSwitchMapping((DNSToSwitchMapping)scriptMapping);
        TestSwitchMapping.assertTrue((String)("Did not find " + scriptname + " in " + mapping), (boolean)mapping.toString().contains(scriptname));
    }

    @Test
    public void testCachingRelaysStringOperationsToNullScript() throws Throwable {
        Configuration conf = new Configuration();
        ScriptBasedMapping scriptMapping = new ScriptBasedMapping(conf);
        TestSwitchMapping.assertTrue((String)("Did not find no script in " + scriptMapping), (boolean)scriptMapping.toString().contains("no script"));
        CachedDNSToSwitchMapping mapping = new CachedDNSToSwitchMapping((DNSToSwitchMapping)scriptMapping);
        TestSwitchMapping.assertTrue((String)("Did not find no script in " + mapping), (boolean)mapping.toString().contains("no script"));
    }

    @Test
    public void testNullMapping() {
        TestSwitchMapping.assertFalse((boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch(null));
    }

    private static class StandaloneSwitchMapping
    implements DNSToSwitchMapping {
        private StandaloneSwitchMapping() {
        }

        public List<String> resolve(List<String> names) {
            return names;
        }
    }
}

