/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.TableMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTableMapping {
    private File mappingFile;

    @Before
    public void setUp() throws IOException {
        this.mappingFile = File.createTempFile(this.getClass().getSimpleName(), ".txt");
        Files.write((CharSequence)"a.b.c /rack1\n1.2.3.4\t/rack2\n", (File)this.mappingFile, (Charset)Charsets.UTF_8);
        this.mappingFile.deleteOnExit();
    }

    @Test
    public void testResolve() throws IOException {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", this.mappingFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/rack1", result.get(0));
        Assert.assertEquals((Object)"/rack2", result.get(1));
    }

    @Test
    public void testTableCaching() throws IOException {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", this.mappingFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List result1 = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result1.size());
        Assert.assertEquals((Object)"/rack1", result1.get(0));
        Assert.assertEquals((Object)"/rack2", result1.get(1));
        conf.set("net.topology.table.file.name", "some bad value for a file");
        List result2 = mapping.resolve(names);
        Assert.assertEquals((Object)result1, (Object)result2);
    }

    @Test
    public void testNoFile() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/default-rack", result.get(0));
        Assert.assertEquals((Object)"/default-rack", result.get(1));
    }

    @Test
    public void testFileDoesNotExist() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", "/this/file/does/not/exist");
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals(result.get(0), (Object)"/default-rack");
        Assert.assertEquals(result.get(1), (Object)"/default-rack");
    }

    @Test
    public void testBadFile() throws IOException {
        Files.write((CharSequence)"bad contents", (File)this.mappingFile, (Charset)Charsets.UTF_8);
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", this.mappingFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3.4");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals(result.get(0), (Object)"/default-rack");
        Assert.assertEquals(result.get(1), (Object)"/default-rack");
    }
}

