/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMapping {
    private DirContext mockContext;
    private LdapGroupsMapping mappingSpy = (LdapGroupsMapping)Mockito.spy((Object)new LdapGroupsMapping());

    @Before
    public void setupMocks() throws NamingException {
        this.mockContext = (DirContext)Mockito.mock(DirContext.class);
        ((LdapGroupsMapping)Mockito.doReturn((Object)this.mockContext).when((Object)this.mappingSpy)).getDirContext();
        NamingEnumeration mockUserNamingEnum = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        NamingEnumeration mockGroupNamingEnum = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        Mockito.when(this.mockContext.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn((Object)mockUserNamingEnum, (Object[])new NamingEnumeration[]{mockGroupNamingEnum});
        SearchResult mockUserResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)mockUserNamingEnum.hasMoreElements()).thenReturn((Object)true);
        Mockito.when(mockUserNamingEnum.nextElement()).thenReturn((Object)mockUserResult);
        Mockito.when((Object)mockUserResult.getNameInNamespace()).thenReturn((Object)"CN=some_user,DC=test,DC=com");
        SearchResult mockGroupResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)mockGroupNamingEnum.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(mockGroupNamingEnum.nextElement()).thenReturn((Object)mockGroupResult);
        BasicAttribute group1Attr = new BasicAttribute("cn");
        group1Attr.add("group1");
        BasicAttributes group1Attrs = new BasicAttributes();
        group1Attrs.put(group1Attr);
        BasicAttribute group2Attr = new BasicAttribute("cn");
        group2Attr.add("group2");
        BasicAttributes group2Attrs = new BasicAttributes();
        group2Attrs.put(group2Attr);
        Mockito.when((Object)mockGroupResult.getAttributes()).thenReturn((Object)group1Attrs, (Object[])new Attributes[]{group2Attrs});
    }

    @Test
    public void testGetGroups() throws IOException, NamingException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        this.mappingSpy.setConf(conf);
        List groups = this.mappingSpy.getGroups("some_user");
        Assert.assertEquals(Arrays.asList("group1", "group2"), (Object)groups);
        ((DirContext)Mockito.verify((Object)this.mockContext, (VerificationMode)Mockito.times((int)2))).search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class));
    }

    @Test
    public void testExtractPassword() throws IOException {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        File secretFile = new File(testDir, "secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write("hadoop");
        ((Writer)writer).close();
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"hadoop", (Object)mapping.extractPassword(secretFile.getPath()));
    }
}

