/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestUserGroupInformation {
    private static final String USER_NAME = "user1@HADOOP.APACHE.ORG";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2", "group3"};

    @BeforeClass
    public static void setup() {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//RULE:[1:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//DEFAULT");
        UserGroupInformation.setConfiguration((Configuration)conf);
        javax.security.auth.login.Configuration.setConfiguration(new DummyLoginConfiguration());
    }

    @Test
    public void testLogin() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assert.assertEquals((Object)UserGroupInformation.getCurrentUser(), (Object)UserGroupInformation.getLoginUser());
        Assert.assertTrue((ugi.getGroupNames().length >= 1 ? 1 : 0) != 0);
        UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        UserGroupInformation curUGI = (UserGroupInformation)userGroupInfo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertEquals((Object)curUGI, (Object)userGroupInfo);
        Assert.assertFalse((boolean)curUGI.equals((Object)UserGroupInformation.getLoginUser()));
    }

    @Test
    public void testGetServerSideGroups() throws IOException, InterruptedException {
        Process pp = Runtime.getRuntime().exec("whoami");
        BufferedReader br = new BufferedReader(new InputStreamReader(pp.getInputStream()));
        String userName = br.readLine().trim();
        pp = Runtime.getRuntime().exec("id -Gn " + userName);
        br = new BufferedReader(new InputStreamReader(pp.getInputStream()));
        String line = br.readLine();
        System.out.println(userName + ":" + line);
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (String s : line.split("[\\s]")) {
            groups.add(s);
        }
        final UserGroupInformation login = UserGroupInformation.getCurrentUser();
        Assert.assertEquals((Object)userName, (Object)login.getShortUserName());
        String[] gi = login.getGroupNames();
        Assert.assertEquals((long)groups.size(), (long)gi.length);
        for (int i = 0; i < gi.length; ++i) {
            Assert.assertTrue((boolean)groups.contains(gi[i]));
        }
        final UserGroupInformation fakeUser = UserGroupInformation.createRemoteUser((String)"foo.bar");
        fakeUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                Assert.assertFalse((boolean)current.equals((Object)login));
                Assert.assertEquals((Object)current, (Object)fakeUser);
                Assert.assertEquals((long)0L, (long)current.getGroupNames().length);
                return null;
            }
        });
    }

    @Test
    public void testConstructor() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"user2/cron@HADOOP.APACHE.ORG", (String[])GROUP_NAMES);
        Assert.assertEquals((Object)"user2/cron@HADOOP.APACHE.ORG", (Object)ugi.getUserName());
        Assert.assertEquals((Object)"user2", (Object)ugi.getShortUserName());
        ugi = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)"user1", (Object)ugi.getShortUserName());
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    private void testConstructorFailures(String userName) {
        boolean gotException = false;
        try {
            UserGroupInformation.createRemoteUser((String)userName);
        }
        catch (Exception e) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test
    public void testEquals() throws Exception {
        UserGroupInformation uugi = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)uugi, (Object)uugi);
        UserGroupInformation ugi2 = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assert.assertFalse((boolean)uugi.equals((Object)ugi2));
        Assert.assertFalse((uugi.hashCode() == ugi2.hashCode() ? 1 : 0) != 0);
        UserGroupInformation ugi3 = new UserGroupInformation(uugi.getSubject());
        Assert.assertEquals((Object)uugi, (Object)ugi3);
        Assert.assertEquals((long)uugi.hashCode(), (long)ugi3.hashCode());
    }

    @Test
    public void testEqualsWithRealUser() throws Exception {
        UserGroupInformation realUgi1 = UserGroupInformation.createUserForTesting((String)"RealUser", (String[])GROUP_NAMES);
        UserGroupInformation realUgi2 = UserGroupInformation.createUserForTesting((String)"RealUser", (String[])GROUP_NAMES);
        UserGroupInformation proxyUgi1 = UserGroupInformation.createProxyUser((String)USER_NAME, (UserGroupInformation)realUgi1);
        UserGroupInformation proxyUgi2 = new UserGroupInformation(proxyUgi1.getSubject());
        UserGroupInformation remoteUgi = UserGroupInformation.createRemoteUser((String)USER_NAME);
        Assert.assertEquals((Object)proxyUgi1, (Object)proxyUgi2);
        Assert.assertFalse((boolean)remoteUgi.equals((Object)proxyUgi1));
    }

    @Test
    public void testGettingGroups() throws Exception {
        UserGroupInformation uugi = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)USER_NAME, (Object)uugi.getUserName());
        Assert.assertArrayEquals((Object[])new String[]{GROUP1_NAME, GROUP2_NAME, GROUP3_NAME}, (Object[])uugi.getGroupNames());
    }

    @Test
    public <T extends TokenIdentifier> void testUGITokens() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"TheDoctor", (String[])new String[]{"TheTARDIS"});
        Token t1 = (Token)Mockito.mock(Token.class);
        Token t2 = (Token)Mockito.mock(Token.class);
        ugi.addToken(t1);
        ugi.addToken(t2);
        Collection z = ugi.getTokens();
        Assert.assertTrue((boolean)z.contains(t1));
        Assert.assertTrue((boolean)z.contains(t2));
        Assert.assertEquals((long)2L, (long)z.size());
        try {
            z.remove(t1);
            Assert.fail((String)"Shouldn't be able to modify token collection from UGI");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        Collection otherSet = (Collection)ugi.doAs(new PrivilegedExceptionAction<Collection<Token<?>>>(){

            @Override
            public Collection<Token<?>> run() throws IOException {
                return UserGroupInformation.getCurrentUser().getTokens();
            }
        });
        Assert.assertTrue((boolean)otherSet.contains(t1));
        Assert.assertTrue((boolean)otherSet.contains(t2));
    }

    @Test
    public void testTokenIdentifiers() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"TheDoctor", (String[])new String[]{"TheTARDIS"});
        TokenIdentifier t1 = (TokenIdentifier)Mockito.mock(TokenIdentifier.class);
        TokenIdentifier t2 = (TokenIdentifier)Mockito.mock(TokenIdentifier.class);
        ugi.addTokenIdentifier(t1);
        ugi.addTokenIdentifier(t2);
        Set z = ugi.getTokenIdentifiers();
        Assert.assertTrue((boolean)z.contains(t1));
        Assert.assertTrue((boolean)z.contains(t2));
        Assert.assertEquals((long)2L, (long)z.size());
        Collection otherSet = (Collection)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<TokenIdentifier>>(){

            @Override
            public Collection<TokenIdentifier> run() throws IOException {
                return UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            }
        });
        Assert.assertTrue((boolean)otherSet.contains(t1));
        Assert.assertTrue((boolean)otherSet.contains(t2));
        Assert.assertEquals((long)2L, (long)otherSet.size());
    }

    @Test
    public void testUGIAuthMethod() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        final UserGroupInformation.AuthenticationMethod am = UserGroupInformation.AuthenticationMethod.KERBEROS;
        ugi.setAuthenticationMethod(am);
        Assert.assertEquals((Object)am, (Object)ugi.getAuthenticationMethod());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Assert.assertEquals((Object)am, (Object)UserGroupInformation.getCurrentUser().getAuthenticationMethod());
                return null;
            }
        });
    }

    @Test
    public void testUGIAuthMethodInRealUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)"proxy", (UserGroupInformation)ugi);
        final UserGroupInformation.AuthenticationMethod am = UserGroupInformation.AuthenticationMethod.KERBEROS;
        ugi.setAuthenticationMethod(am);
        Assert.assertEquals((Object)am, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)proxyUgi.getAuthenticationMethod());
        Assert.assertEquals((Object)am, (Object)UserGroupInformation.getRealAuthenticationMethod((UserGroupInformation)proxyUgi));
        proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)UserGroupInformation.getCurrentUser().getAuthenticationMethod());
                Assert.assertEquals((Object)am, (Object)UserGroupInformation.getCurrentUser().getRealUser().getAuthenticationMethod());
                return null;
            }
        });
        UserGroupInformation proxyUgi2 = new UserGroupInformation(proxyUgi.getSubject());
        proxyUgi2.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
        Assert.assertEquals((Object)proxyUgi, (Object)proxyUgi2);
        UserGroupInformation realugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUgi3 = UserGroupInformation.createProxyUser((String)"proxyAnother", (UserGroupInformation)realugi);
        UserGroupInformation proxyUgi4 = new UserGroupInformation(proxyUgi3.getSubject());
        Assert.assertEquals((Object)proxyUgi3, (Object)proxyUgi4);
    }

    @Test
    public void testLoginObjectInSubject() throws Exception {
        LoginContext login2;
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        UserGroupInformation anotherUgi = new UserGroupInformation(loginUgi.getSubject());
        LoginContext login1 = loginUgi.getSubject().getPrincipals(User.class).iterator().next().getLogin();
        Assert.assertTrue((login1 == (login2 = anotherUgi.getSubject().getPrincipals(User.class).iterator().next().getLogin()) ? 1 : 0) != 0);
    }

    @Test
    public void testLoginModuleCommit() throws Exception {
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        User user1 = loginUgi.getSubject().getPrincipals(User.class).iterator().next();
        LoginContext login = user1.getLogin();
        login.logout();
        login.login();
        User user2 = loginUgi.getSubject().getPrincipals(User.class).iterator().next();
        Assert.assertTrue((user1 == user2 ? 1 : 0) != 0);
    }

    public static void verifyLoginMetrics(long success, int failure) throws IOException {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("UgiMetrics");
        if (success > 0L) {
            MetricsAsserts.assertCounter("LoginSuccessNumOps", success, rb);
            MetricsAsserts.assertGaugeGt("LoginSuccessAvgTime", 0.0, rb);
        }
        if (failure > 0) {
            MetricsAsserts.assertCounter("LoginFailureNumPos", failure, rb);
            MetricsAsserts.assertGaugeGt("LoginFailureAvgTime", 0.0, rb);
        }
    }

    @Test
    public void testUGIUnderNonHadoopContext() throws Exception {
        Subject nonHadoopSubject = new Subject();
        Subject.doAs(nonHadoopSubject, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                Assert.assertNotNull((Object)ugi);
                return null;
            }
        });
    }

    private static class DummyLoginConfiguration
    extends javax.security.auth.login.Configuration {
        private DummyLoginConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            throw new RuntimeException("UGI is not using its own security conf!");
        }
    }
}

