/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class KeyStoreTestUtil {
    public static String getClasspathDir(Class klass) throws Exception {
        String file = klass.getName();
        file = file.replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - file.length() - 1);
        return baseDir;
    }

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws GeneralSecurityException, IOException {
        PrivateKey privkey = pair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        CertificateValidity interval = new CertificateValidity(from, to);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner = new X500Name(dn);
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(sn));
        info.set("subject", new CertificateSubjectName(owner));
        info.set("issuer", new CertificateIssuerName(owner));
        info.set("key", new CertificateX509Key(pair.getPublic()));
        info.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        return cert;
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(1024);
        return keyGen.genKeyPair();
    }

    private static KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveKeyStore(KeyStore ks, String filename, String password) throws GeneralSecurityException, IOException {
        FileOutputStream out = new FileOutputStream(filename);
        try {
            ks.store(out, password.toCharArray());
        }
        finally {
            out.close();
        }
    }

    public static void createKeyStore(String filename, String password, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{cert});
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createTrustStore(String filename, String password, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setCertificateEntry(alias, cert);
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static <T extends Certificate> void createTrustStore(String filename, String password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void cleanupSSLConfig(String keystoresDir, String sslConfDir) throws Exception {
        File f = new File(keystoresDir + "/clientKS.jks");
        f.delete();
        f = new File(keystoresDir + "/serverKS.jks");
        f.delete();
        f = new File(keystoresDir + "/trustKS.jks");
        f.delete();
        f = new File(sslConfDir + "/ssl-client.xml");
        f.delete();
        f = new File(sslConfDir + "/ssl-server.xml");
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert) throws Exception {
        String clientKS = keystoresDir + "/clientKS.jks";
        String clientPassword = "clientP";
        String serverKS = keystoresDir + "/serverKS.jks";
        String serverPassword = "serverP";
        String trustKS = keystoresDir + "/trustKS.jks";
        String trustPassword = "trustP";
        File sslClientConfFile = new File(sslConfDir + "/ssl-client.xml");
        File sslServerConfFile = new File(sslConfDir + "/ssl-server.xml");
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        if (useClientCert) {
            KeyPair cKP = KeyStoreTestUtil.generateKeyPair("RSA");
            X509Certificate cCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=client", cKP, 30, "SHA1withRSA");
            KeyStoreTestUtil.createKeyStore(clientKS, clientPassword, "client", cKP.getPrivate(), cCert);
            certs.put("client", cCert);
        }
        KeyPair sKP = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate sCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=server", sKP, 30, "SHA1withRSA");
        KeyStoreTestUtil.createKeyStore(serverKS, serverPassword, "server", sKP.getPrivate(), sCert);
        certs.put("server", sCert);
        KeyStoreTestUtil.createTrustStore(trustKS, trustPassword, certs);
        Configuration clientSSLConf = new Configuration(false);
        clientSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.keystore.location"), clientKS);
        clientSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.keystore.password"), clientPassword);
        clientSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.truststore.location"), trustKS);
        clientSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.truststore.password"), trustPassword);
        clientSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        Configuration serverSSLConf = new Configuration(false);
        serverSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.location"), serverKS);
        serverSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"), serverPassword);
        serverSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.location"), trustKS);
        serverSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.password"), trustPassword);
        serverSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        FileWriter writer = new FileWriter(sslClientConfFile);
        try {
            clientSSLConf.writeXml((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        writer = new FileWriter(sslServerConfFile);
        try {
            serverSSLConf.writeXml((Writer)writer);
        }
        finally {
            ((Writer)writer).close();
        }
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        conf.set("hadoop.ssl.client.conf", sslClientConfFile.getName());
        conf.set("hadoop.ssl.server.conf", sslServerConfFile.getName());
        conf.setBoolean("hadoop.ssl.require.client.cert", useClientCert);
    }
}

