/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSSLFactory {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestSSLFactory.class.getSimpleName();

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    private Configuration createConfiguration(boolean clientCert) throws Exception {
        Configuration conf = new Configuration();
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        String sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestSSLFactory.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfsDir, conf, clientCert);
        return conf;
    }

    @After
    @Before
    public void cleanUp() throws Exception {
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        String sslConfsDir = KeyStoreTestUtil.getClasspathDir(TestSSLFactory.class);
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void clientMode() throws Exception {
        Configuration conf = this.createConfiguration(false);
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
            Assert.assertNotNull((Object)sslFactory.createSSLSocketFactory());
            Assert.assertNotNull((Object)sslFactory.getHostnameVerifier());
            sslFactory.createSSLServerSocketFactory();
        }
        finally {
            sslFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverMode(boolean clientCert, boolean socket) throws Exception {
        Configuration conf = this.createConfiguration(clientCert);
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
        try {
            sslFactory.init();
            Assert.assertNotNull((Object)sslFactory.createSSLServerSocketFactory());
            Assert.assertEquals((Object)clientCert, (Object)sslFactory.isClientCertRequired());
            if (socket) {
                sslFactory.createSSLSocketFactory();
            } else {
                sslFactory.getHostnameVerifier();
            }
        }
        finally {
            sslFactory.destroy();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithoutClientCertsSocket() throws Exception {
        this.serverMode(false, true);
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithClientCertsSocket() throws Exception {
        this.serverMode(true, true);
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithoutClientCertsVerifier() throws Exception {
        this.serverMode(false, false);
    }

    @Test(expected=IllegalStateException.class)
    public void serverModeWithClientCertsVerifier() throws Exception {
        this.serverMode(true, false);
    }

    @Test
    public void validHostnameVerifier() throws Exception {
        Configuration conf = this.createConfiguration(false);
        conf.unset("hadoop.ssl.hostname.verifier");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"DEFAULT", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"ALLOW_ALL", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "DEFAULT_AND_LOCALHOST");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"DEFAULT_AND_LOCALHOST", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "STRICT");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"STRICT", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
        conf.set("hadoop.ssl.hostname.verifier", "STRICT_IE6");
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        Assert.assertEquals((Object)"STRICT_IE6", (Object)sslFactory.getHostnameVerifier().toString());
        sslFactory.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=GeneralSecurityException.class)
    public void invalidHostnameVerifier() throws Exception {
        Configuration conf = this.createConfiguration(false);
        conf.set("hadoop.ssl.hostname.verifier", "foo");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
        }
        finally {
            sslFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionConfigurator() throws Exception {
        Configuration conf = this.createConfiguration(false);
        conf.set("hadoop.ssl.hostname.verifier", "STRICT_IE6");
        SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        try {
            sslFactory.init();
            HttpsURLConnection sslConn = (HttpsURLConnection)new URL("https://foo").openConnection();
            Assert.assertNotSame((Object)"STRICT_IE6", (Object)sslConn.getHostnameVerifier().toString());
            sslFactory.configure((HttpURLConnection)sslConn);
            Assert.assertEquals((Object)"STRICT_IE6", (Object)sslConn.getHostnameVerifier().toString());
        }
        finally {
            sslFactory.destroy();
        }
    }
}

